/*===========================================================================
 * 
 * Project : Mink
 * Author  : Terry 'Mongoose' Hendrix II
 * Website : http://icculus.org/~mongoose
 * Email   : mongooseichiban@gmail.com
 * Object  : MinkApplet
 * License : GPL
 * Comments: I wrote this one day to see how Gnome# applets work.
 *
 *-- TODO ---------------------------------------------------
 *
 * - Add pretty graphics
 *
 *-- History ------------------------------------------------ 
 *
 * 2006.09.02:
 * Mongoose - Created
 *            With no documentation I found a sample text label applet, and
 *            then I reworked the ink interface with printers.
 ==========================================================================*/

using System;
using System.Runtime.InteropServices;
using System.Threading;
using Gtk;
using Gnome;
using GConf;


/* HOWTO make bonobo see this applet exists:
 *
 * 1. Make a MinkApplet_Factory.server xml file.  ( I've done this for you. )
 *
 * 2. Copy file to /usr/lib/bonobo/servers/
 *
 * 3. Should be able to see it with bonobo-browser now.
 *
 * 4. You may have to restart GNOME to make it show up in add applet dialog.
 *
 */
 
class MinkTimer 
{
    public int counter = 0;
    public Timer timer;
}


public class MinkApplet : Gnome.PanelApplet
{	
	// C#/C inklevel library binding 
	
	// These enums duplicate preprocessor defines in inklevel.h

	/* Values for port */
	enum inklevel_port {
		PARPORT = 1,
		USB = 2
	};

	/* Values for ink_level.type */
	enum inklevel_type {
		RESPONSE_INVALID = 0,
		ONE_COLOR_FOUND = 1,
		ONE_BLACK_COLOR_FOUND = 2,
		TWO_COLORS_FOUND = 3,
		TWO_PHOTO_COLORS_FOUND = 4,
		THREE_COLORS_FOUND = 5,
		FOUR_COLORS_FOUND = 6,
		SIX_COLORS_FOUND = 7,
		SEVEN_COLORS_FOUND = 8
	};

	/* Possible return values for get_ink_level() */
	enum inklevel_status {
		OK = 0,
		ERROR = -1,
		DEV_PARPORT_INACCESSIBLE = -2,
		DEV_LP_INACCESSIBLE = -3,
		COULD_NOT_GET_DEVICE_ID = -4,
		DEV_USB_LP_INACCESSIBLE = -5,
		UNKNOWN_PORT_SPECIFIED  =-6,
		NO_PRINTER_FOUND = -7,
		NO_DEVICE_CLASS_FOUND = -8,
		NO_CMD_TAG_FOUND = -9,
		PRINTER_NOT_SUPPORTED  =-10,
		NO_INK_LEVEL_FOUND = -11,
		COULD_NOT_WRITE_TO_PRINTER  =-12,
		COULD_NOT_READ_FROM_PRINTER = -13,
		COULD_NOT_PARSE_RESPONSE_FROM_PRINTER = -14
	};

	enum inklevel_misc {
		MODEL_NAME_LENGTH = 100
	};
	
	// NOTE: In the libinklevel I modified these are unsigned
	[StructLayout(LayoutKind.Sequential)]
	public struct ink_level { 
		internal fixed byte model[inklevel_misc.MODEL_NAME_LENGTH];
		public ushort type;
		public ushort black;
		public ushort color;
		public ushort cyan;
		public ushort magenta;
		public ushort yellow;
		public ushort photo;
		public ushort photocyan;
		public ushort photomagenta;
		public ushort photoyellow;
	}

	// int get_ink_level(int port, int portnumber, struct ink_level *level);
	[DllImport("inklevel", EntryPoint="get_ink_level")]
	public extern static int get_ink_level(int port, int portnumber, ref ink_level level);


	// Applet	
	public MinkApplet(IntPtr raw) : base (raw)
	{
	}
	

	public static void Main(string[] args)
	{
		mProgram = new Gnome.Program("MinkApplet", "0.1", Gnome.Modules.UI, args);
		PanelAppletFactory.Register(typeof(MinkApplet));
	}


	public override void Creation()
	{
		mPort = 2; // 1 = paralellport, 2 = usb
		mPortnumber = 0;
		mMinsToUpdate = 5;
	
		this.Add(new Image(Gtk.Stock.Print, IconSize.Menu));
		//mLabel = new Label("mink");
		//mLabel.Markup = "<small>" + mLabel.Text + "</small>";
		//this.Add(mLabel);
		mTips = new Tooltips();
		this.ShowAll();
	
		// Applet menu
		string xml = "<popup name=\"button3\">" +
				// menu items
				"<menuitem name=\"Update\" verb=\"Update\" _label=\"_Update\" pixtype=\"stock\" pixname=\"gtk-refresh\"/>" +
				"<menuitem name=\"Preferences\" verb=\"ShowPreferences\" _label=\"_Preferences\" pixtype=\"stock\" pixname=\"gtk-properties\"/>" +
				"<menuitem name=\"About\" verb=\"ShowAbout\" _label=\"_About\" pixtype=\"stock\" pixname=\"gtk-about\"/>" +
				"</popup>";
		
		mMenuVerbs = new BonoboUIVerb [] {
			new BonoboUIVerb ("Update", new ContextMenuItemCallback(UpdateInkLevel)),
			new BonoboUIVerb ("ShowPreferences", new ContextMenuItemCallback(ShowPreferences)),
			new BonoboUIVerb ("ShowAbout", new ContextMenuItemCallback(ShowAbout))
		};
			
		this.SetupMenu(xml, mMenuVerbs);

		// User settings persistance
		LoadSettings();
		
		// Timer for polling printer
		MinkTimer t = new MinkTimer();
		TimerCallback timerCB = new TimerCallback(TimerRefresh);
		Timer timer = new Timer(timerCB, t, 60000, 60000); // 1 min to start, 1min
		t.timer = timer;
		
		// This is here to avoid bad GC, normally would just call via normal call
		mInstance = this;
		mInstance.UpdateInkLevel();
	}
	
	
	private void TimerRefresh(System.Object state) 
	{
		MinkTimer t = (MinkTimer)state;
		t.counter++;
		Console.WriteLine("{0} Checking min {1}.", DateTime.Now.TimeOfDay, t.counter);
        
		if (t.counter == mMinsToUpdate) 
		{
			mInstance.UpdateInkLevel();
			t.counter = 0;
    	}
	}
	
	
	private void LoadSettings()
	{
		GConf.Client client = new GConf.Client();

		try
		{
			mPort = (int)client.Get("/apps/minkapplet/port");
		}
		catch (GConf.NoSuchKeyException)
		{
			client.Set("/apps/minkapplet/port", mPort);        
		}
		
		try
		{
			mPortnumber = (int)client.Get("/apps/minkapplet/portnumber");
		}
		catch (GConf.NoSuchKeyException)
		{
			client.Set("/apps/minkapplet/portnumber", mPortnumber);        
		}	
		
		try
		{
			mMinsToUpdate = (int)client.Get("/apps/minkapplet/minstoupdate");
		}
		catch (GConf.NoSuchKeyException)
		{
			client.Set("/apps/minkapplet/minstoupdate", mMinsToUpdate);        
		}	
	}


	public void ShowPreferences()
	{
        mPreferencesDialog = new Gtk.Window("Mink Preferences");
        
		VBox box = new VBox(false, 4);
		mPreferencesDialog.Add(box);

		HBox hbox = new HBox(false, 2);
		SpinButton spinner = new SpinButton(0f, 10f, 1f);
		spinner.Value = mPortnumber;
		spinner.ValueChanged += new EventHandler(OutputValue);
		hbox.PackEnd(spinner);
		Label label = new Label("Device number");
		hbox.PackEnd(label);
		box.PackEnd(hbox);

		HBox hbox2 = new HBox(false, 2);
		SpinButton spinner2 = new SpinButton(1f, 10f, 1f);
		spinner2.Value = mMinsToUpdate;
		spinner2.ValueChanged += new EventHandler(OutputValue2);
		hbox2.PackEnd(spinner2);
		Label label2 = new Label("Minutes to update");
		hbox2.PackEnd(label2);
		box.PackEnd(hbox2);

        ComboBox combo = ComboBox.NewText();
		combo.AppendText("Parallel Port");
		combo.AppendText("USB");
		combo.Active = mPort - 1;
		combo.Changed += new EventHandler(OnComboBoxChanged);
		box.PackEnd(combo);
				
        mPreferencesDialog.ShowAll();
	}
	
	
	private void OutputValue(object source, System.EventArgs args)
	{
    	SpinButton spinner = source as SpinButton;
    	mPortnumber = spinner.ValueAsInt;		
		GConf.Client client = new GConf.Client();
		client.Set("/apps/minkapplet/portnumber", mPortnumber);      
    	UpdateInkLevel();
	}
	

	private void OutputValue2(object source, System.EventArgs args)
	{
    	SpinButton spinner = source as SpinButton;
    	mMinsToUpdate = spinner.ValueAsInt;		
		GConf.Client client = new GConf.Client();
		client.Set("/apps/minkapplet/minstoupdate", mMinsToUpdate);      
    	UpdateInkLevel();
	}
	
	
	private void OnComboBoxChanged(object o, EventArgs args)
	{
		ComboBox combo = o as ComboBox;
          
		if (o == null)
			return;

		TreeIter iter;

		if (combo.GetActiveIter(out iter))
		{
			mPort = ((string)combo.Model.GetValue(iter, 0) == "USB") ? 2 : 1;		
			GConf.Client client = new GConf.Client();
			client.Set("/apps/minkapplet/port", mPort);        
			UpdateInkLevel();
		}
	}


	public void ShowAbout() 
	{
        string[] authors = {"Terry 'Mongoose' Hendrix II"};
        string[] documenters = {"Terry 'Mongoose' Hendrix II"};

        mAboutDialog = new AboutDialog();
        mAboutDialog.Authors = authors;
        mAboutDialog.Documenters = documenters;
        mAboutDialog.Copyright = "2006 Terry 'Mongoose' Hendrix II";
        mAboutDialog.License = "GPL 2.0";
        mAboutDialog.Name = "Mink - Printer Ink Monitor";
        mAboutDialog.Version = "0.1";
        mAboutDialog.Website = "http://icculus.org/~mongoose";
        mAboutDialog.Run();
    }
    

	public void UpdateInkLevel()
	{
		ink_level level = new ink_level();
		int result = get_ink_level(mPort, mPortnumber, ref level);
		int size = (int)inklevel_misc.MODEL_NAME_LENGTH;

/*
		char[] buf = new char[size];
		
		for (int i = 0; i < size; ++i)
		{
			buf[i] = (char)level.model[i];
		}
		
		// C/C# string issues caused a malform string here 
		// ( Couldn't append to strings based off this string 
		//   likey cause was multiple '\0's )
		string model = new string(buf);
*/
		string model = "";
		
		for (int i = 0; i < size; ++i)
		{
			if (level.model[i] == 0)
				break;

			model += (char)level.model[i];
		}

		if ((inklevel_status)result == inklevel_status.OK)
		{
			string status = "";
			string sep = "\n"; 
			status = model + sep;
		
			switch ((inklevel_type)level.type)
			{
			case inklevel_type.RESPONSE_INVALID:
				status += "No ink level was reported." + sep;
				break;
				
			case inklevel_type.ONE_COLOR_FOUND:
				status += "Color: " + level.color + "%" + sep;
				break;
				
			case inklevel_type.ONE_BLACK_COLOR_FOUND:
				status += "Black: " + level.black + "%" + sep;
				break;
				
			case inklevel_type.TWO_COLORS_FOUND:
				status += "Black: " + level.black + "%" + sep;
				status += "Color: " + level.color + "%" + sep;
				break;
				
			case inklevel_type.TWO_PHOTO_COLORS_FOUND:
				status += "Photo: " + level.photo + "%" + sep;
				status += "Color: " + level.color + "%" + sep;
				break;
				
			case inklevel_type.THREE_COLORS_FOUND:
				status += "Cyan: " + level.cyan + "%" + sep;
				status += "Magenta: " + level.magenta + "%" + sep;
				status += "Yellow: " + level.yellow + "%" + sep;
				break;
				
			case inklevel_type.FOUR_COLORS_FOUND:
				status += "Black: " + level.black + "%" + sep;
				status += "Cyan: " + level.cyan + "%" + sep;
				status += "Magenta: " + level.magenta + "%" + sep;
				status += "Yellow: " + level.yellow + "%" + sep;
				break;
				
			case inklevel_type.SIX_COLORS_FOUND:
				status += "Black: " + level.black + "%" + sep;
				status += "Cyan: " + level.cyan + "%" + sep;
				status += "Magenta: " + level.magenta + "%" + sep;
				status += "Yellow: " + level.yellow + "%" + sep;
				status += "Photocyan: " + level. photocyan+ "%" + sep;
				status += "Photomagenta: " + level.photomagenta + "%" + sep;
				break;
				
			case inklevel_type.SEVEN_COLORS_FOUND:
				status += "Black: " + level.black + "%" + sep;
				status += "Cyan: " + level.cyan + "%" + sep;
				status += "Magenta: " + level.magenta + "%" + sep;
				status += "Yellow: " + level.yellow + "%" + sep;
				status += "Photocyan: " + level.photocyan + "%" + sep;
				status += "Photomagenta: " + level.photomagenta + "%" + sep;
				status += "Photoyellow: " + level.photoyellow + "%" + sep;
				break;
				
			default:
				status += "Unknown ink color type." + sep;
				break;
			}
			
			mTips.SetTip(this, status, null);
			mTips.Enable();
			mTips.Sink();
		}
		else
		{
			string status = model + "\n";

			switch ((inklevel_status)result)
			{
			case inklevel_status.DEV_PARPORT_INACCESSIBLE:
				status += "Could not access '/dev/parport" + mPortnumber + "'.";
				break;
				
			case inklevel_status.DEV_LP_INACCESSIBLE:
				status += "Could not access '/dev/lp" + mPortnumber + "'.";
				break;
				
			case inklevel_status.COULD_NOT_GET_DEVICE_ID:
				status += "Could not get device id.";
				break;
				
			case inklevel_status.DEV_USB_LP_INACCESSIBLE:
				status += "Could not access '/dev/usb/lp" + mPortnumber + "'.";
				break;
				
			case inklevel_status.UNKNOWN_PORT_SPECIFIED:
				status += "Unknown port specified.";
				break;
				
			case inklevel_status.NO_PRINTER_FOUND:
				status += "No printer found.";
				break;
				
			case inklevel_status.NO_DEVICE_CLASS_FOUND:
				status += "No device class found.";
				break;
				
			case inklevel_status.NO_CMD_TAG_FOUND:
				status += "No cmd tag found.";
				break;
				
			case inklevel_status.PRINTER_NOT_SUPPORTED:
				status += "Printer not supported.";
				break;
				
			case inklevel_status.NO_INK_LEVEL_FOUND:
				status += "No ink level found.";
				break;
				
			case inklevel_status.COULD_NOT_WRITE_TO_PRINTER:
				status += "Could not write to printer.";
				break;
				
			case inklevel_status.COULD_NOT_READ_FROM_PRINTER:
				status += "Could not read from printer.";
				break;
				
			case inklevel_status.COULD_NOT_PARSE_RESPONSE_FROM_PRINTER:
				status += "Could not parse response from printer.";
				break;
				
			default:				
				status += "Could not determine printer status.";
				break;
			}
			
			Console.WriteLine(status);
			mTips.SetTip(this, status, null);
			mTips.Enable();
			mTips.Sink();
		}
	}


	public override string IID {
		get { return "OAFIID:MinkApplet"; }
	}


	public override string FactoryIID {
		get { return "OAFIID:MinkApplet_Factory"; }
	}


	static MinkApplet mInstance;   // This is used to avoid bad GC behavoir
	
	static Gnome.Program mProgram;

	int mPort; // 1 = paralellport, 2 = usb

	int mPortnumber;
	
	int mMinsToUpdate;
	
	BonoboUIVerb [] mMenuVerbs;
	
	Tooltips mTips;

	//Gdk.Pixbuf mIcon; 
	//Label mLabel;
		
	Gtk.Window mPreferencesDialog;
	
	AboutDialog mAboutDialog;
}