/* inklevel.h
 *
 * (c) 2003 Markus Heinz
 *
 * This software is licensed under the terms of the GPL.
 * For details see file COPYING.
 */

#ifndef INKLEVEL_H
#define INKLEVEL_H

/* Values for port */

#define PARPORT 1
#define USB 2

/* Values for ink_level.type */

#define RESPONSE_INVALID 0
#define ONE_COLOR_FOUND 1
#define ONE_BLACK_COLOR_FOUND 2
#define TWO_COLORS_FOUND 3
#define TWO_PHOTO_COLORS_FOUND 4
#define THREE_COLORS_FOUND 5
#define FOUR_COLORS_FOUND 6
#define SIX_COLORS_FOUND 7
#define SEVEN_COLORS_FOUND 8

/* Possible return values for get_ink_level() */

#define OK 0
#define ERROR -1
#define DEV_PARPORT_INACCESSIBLE -2
#define DEV_LP_INACCESSIBLE -3
#define COULD_NOT_GET_DEVICE_ID -4
#define DEV_USB_LP_INACCESSIBLE -5
#define UNKNOWN_PORT_SPECIFIED -6
#define NO_PRINTER_FOUND -7
#define NO_DEVICE_CLASS_FOUND -8
#define NO_CMD_TAG_FOUND -9
#define PRINTER_NOT_SUPPORTED -10
#define NO_INK_LEVEL_FOUND -11
#define COULD_NOT_WRITE_TO_PRINTER -12
#define COULD_NOT_READ_FROM_PRINTER -13
#define COULD_NOT_PARSE_RESPONSE_FROM_PRINTER -14

#define MODEL_NAME_LENGTH 100

struct ink_level {
  unsigned char model[MODEL_NAME_LENGTH];
  unsigned short type;
  unsigned short black;
  unsigned short color;
  unsigned short cyan;
  unsigned short magenta;
  unsigned short yellow;
  unsigned short photo;
  unsigned short photocyan;
  unsigned short photomagenta;
  unsigned short photoyellow;
};

int get_ink_level(int port, int portnumber, struct ink_level *level);

#endif
