/*
 * Decompiled with CFR 0.152.
 */
package ReflWrap;

import ReflWrap.ByteCode;
import ReflWrap.MethodInfo;
import ReflWrap.Refl;
import ReflWrap.sFID;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo {
    private Class klasse;
    private String name;
    private String fqcn;
    private Method[] m;
    private Method[] m_ord;

    public ClassInfo(String FQCN) throws ClassNotFoundException {
        this(Class.forName(Refl.firstToken(FQCN, "<")));
        if (Refl.hasToken(FQCN, "<")) {
            String moo = Refl.lastToken(FQCN, "<");
            StringTokenizer tok = new StringTokenizer(moo.substring(0, moo.length() - 1), ",");
            System.out.println(tok);
        }
    }

    public ClassInfo(Class klasse) {
        this.klasse = klasse;
        this.fqcn = klasse.getName();
        if (this.fqcn.equals("java.lang.Boolean")) {
            this.fqcn = "boolean";
        }
        if (this.fqcn.equals("java.lang.Byte")) {
            this.fqcn = "byte";
        }
        if (this.fqcn.equals("java.lang.Character")) {
            this.fqcn = "char";
        }
        if (this.fqcn.equals("java.lang.Double")) {
            this.fqcn = "double";
        }
        if (this.fqcn.equals("java.lang.Float")) {
            this.fqcn = "float";
        }
        if (this.fqcn.equals("java.lang.Integer")) {
            this.fqcn = "int";
        }
        if (this.fqcn.equals("java.lang.Long")) {
            this.fqcn = "long";
        }
        if (this.fqcn.equals("java.lang.Short")) {
            this.fqcn = "short";
        }
        if (this.fqcn.equals("java.lang.Void")) {
            this.fqcn = "void";
        }
        if (this.isArray()) {
            this.name = this.arrayType().getCanonicalName() + "[]";
        } else {
            StringTokenizer str = new StringTokenizer(this.fqcn, ".");
            this.name = null;
            while (str.hasMoreTokens()) {
                this.name = str.nextToken();
            }
        }
        this.m = null;
        this.m_ord = ClassInfo.orderMethods(klasse.getMethods());
    }

    private static Method[] orderMethods(Method[] old_m) {
        int i;
        Method[] ret = new Method[old_m.length];
        for (i = 0; i < ret.length; ++i) {
            if (!old_m[i].isAnnotationPresent(sFID.class)) continue;
            short fid = old_m[i].getAnnotation(sFID.class).value();
            ret[fid - 1] = old_m[i];
            old_m[i] = null;
        }
        for (i = 0; i < ret.length; ++i) {
            if (old_m[i] == null) continue;
            for (int j = i; j < ret.length; ++j) {
                if (ret[j] != null) continue;
                ret[j] = old_m[i];
                old_m[i] = null;
            }
        }
        return ret;
    }

    public <C extends Class<? extends Annotation>> boolean isAnot(C klass) {
        return this.klasse.isAnnotationPresent(klass);
    }

    public String fqcn() {
        return this.fqcn;
    }

    public String fqcncs() {
        return ByteCode.sed(this.fqcn(), "\\.", "::");
    }

    public static String cncs2java(String name) {
        return ByteCode.sed(name, "::", "\\.");
    }

    public String filename() {
        StringBuffer buf = new StringBuffer();
        StringTokenizer str = new StringTokenizer(this.fqcn(), ".");
        while (str.hasMoreTokens()) {
            buf.append(str.nextToken() + (str.hasMoreTokens() ? "/" : ".class"));
        }
        return buf.toString();
    }

    public String _package() {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(this.fqcn(), ".");
        while (tok.countTokens() > 1) {
            buf.append(tok.nextToken() + (tok.countTokens() > 2 ? "." : ""));
        }
        return buf.toString();
    }

    public String name() {
        return this.name;
    }

    public Class _class() {
        return this.klasse;
    }

    public Method[] methods() {
        return this.m_ord;
    }

    public Method[] meth_here() {
        if (this.m != null) {
            return this.m;
        }
        int num = 0;
        for (int i = 0; i < this.m_ord.length; ++i) {
            if (!this.m_ord[i].getDeclaringClass().equals(this.klasse)) continue;
            ++num;
        }
        this.m = new Method[num];
        int j = 0;
        for (int i = 0; i < this.m_ord.length; ++i) {
            if (!this.m_ord[i].getDeclaringClass().equals(this.klasse)) continue;
            this.m[j] = this.m_ord[i];
            ++j;
        }
        return this.m;
    }

    public Constructor[] constructors() {
        return this.klasse.getConstructors();
    }

    public Class[] interfaces() {
        return this.klasse.getInterfaces();
    }

    public boolean implementing(String klass) {
        ClassInfo supper;
        if (this.sclass() != null && (supper = new ClassInfo(this.sclass())).implementing(klass)) {
            return true;
        }
        for (int i = 0; i < this.interfaces().length; ++i) {
            if (!this.interfaces()[i].getName().equals(klass)) continue;
            return true;
        }
        return false;
    }

    public String superclass() {
        return new ClassInfo(this.klasse.getSuperclass()).name();
    }

    public String fqsuperclass() {
        return this.klasse.getSuperclass().getName();
    }

    public Class sclass() {
        return this.klasse.getSuperclass();
    }

    public String toString() {
        return this.klasse.toString();
    }

    public Field[] fields() {
        return this.klasse.getDeclaredFields();
    }

    public static void dumpMethods(Class klasse) {
        Method[] mm = ClassInfo.orderMethods(klasse.getMethods());
        for (int i = 0; i < mm.length; ++i) {
            System.out.print(i + ". " + new MethodInfo(mm[i]));
        }
    }

    public Class arrayType() {
        int i = 0;
        while (this.fqcn.charAt(i) == '[') {
            ++i;
        }
        if (i > 0) {
            String type = this.fqcn.substring(i, this.fqcn.length());
            if (type.equals("Z")) {
                return Boolean.TYPE;
            }
            if (type.equals("B")) {
                return Byte.TYPE;
            }
            if (type.equals("C")) {
                return Character.TYPE;
            }
            if (type.equals("D")) {
                return Double.TYPE;
            }
            if (type.equals("F")) {
                return Float.TYPE;
            }
            if (type.equals("I")) {
                return Integer.TYPE;
            }
            if (type.equals("J")) {
                return Long.TYPE;
            }
            if (type.equals("S")) {
                return Short.TYPE;
            }
            try {
                if (type.charAt(0) == 'L') {
                    return Class.forName(this.fqcn.substring(i + 1, this.fqcn.length() - 1));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            System.err.println("ERROR: " + type + " .");
        }
        return null;
    }

    public String clstr() {
        if (this.fqcn.equals("boolean")) {
            return "Boolean.TYPE";
        }
        if (this.fqcn.equals("byte")) {
            return "Byte.TYPE";
        }
        if (this.fqcn.equals("char")) {
            return "Character.TYPE";
        }
        if (this.fqcn.equals("double")) {
            return "Double.TYPE";
        }
        if (this.fqcn.equals("float")) {
            return "Float.TYPE";
        }
        if (this.fqcn.equals("int")) {
            return "Integer.TYPE";
        }
        if (this.fqcn.equals("long")) {
            return "Long.TYPE";
        }
        if (this.fqcn.equals("short")) {
            return "Short.TYPE";
        }
        if (this.fqcn.equals("void")) {
            return "Void.class";
        }
        if (this.klasse.isArray()) {
            StringBuffer buf = new StringBuffer();
            buf.append("(new " + this.arrayType().getCanonicalName());
            int i = 0;
            while (this.fqcn.charAt(i) == '[') {
                ++i;
            }
            for (int j = 0; j < i; ++j) {
                buf.append("[0]");
            }
            buf.append(").getClass()");
            return buf.toString();
        }
        return this.fqcn + ".class";
    }

    public boolean equals(Object data) {
        if (!(data instanceof ClassInfo)) {
            return false;
        }
        return this.fqcn() == ((ClassInfo)data).fqcn();
    }

    public boolean isArray() {
        return this.klasse.isArray();
    }

    public LinkedList<String> methodList() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Method m : this.methods()) {
            if (m.getDeclaringClass() != this._class()) continue;
            ret.add(new MethodInfo(m).toSimpleString());
        }
        return ret;
    }

    public boolean hasMethod(String name) {
        for (Method m : this.meth_here()) {
            if (!m.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

