/*
 * Decompiled with CFR 0.152.
 */
package DotClass;

import DotClass.ClassList;
import DotClass.ClassListEntry;
import DotClass.DefaultStyle;
import ReflWrap.ClassInfo;
import java.io.File;
import java.io.FileWriter;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class Main {
    public static void resolveSymbol(ClassList list, Class klasse) {
        if (klasse == null) {
            return;
        }
        if (klasse.getName().equals("java.lang.Object")) {
            list.add(new ClassInfo(klasse));
            return;
        }
        ClassInfo cinfo = new ClassInfo(klasse);
        list.add(cinfo);
        Main.resolveSymbol(list, cinfo.sclass());
        for (int j = 0; j < cinfo.interfaces().length; ++j) {
            Main.resolveSymbol(list, cinfo.interfaces()[j]);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("DotClass - generate class hierarchy graphs.");
            System.out.println("\nUsage: java Tools.DotClass [directory] [package]");
            System.exit(1);
        }
        try {
            ClassListEntry entry;
            File dir = new File(args[0] + "/" + args[1]);
            File[] classes = dir.listFiles();
            ClassList list = new ClassList();
            if (classes == null) {
                System.out.println("No classes found.");
                System.exit(2);
            }
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i].getName().equals("CVS") || classes[i].getName().equals(".cvsignore") || classes[i].getName().equals(".svn")) continue;
                StringTokenizer tok = new StringTokenizer(classes[i].getName(), ".");
                Main.resolveSymbol(list, Class.forName(args[1] + "." + tok.nextToken()));
            }
            FileWriter ofile = new FileWriter(args[1] + ".dot");
            ofile.write("digraph " + args[1] + "\n{\n");
            ListIterator iter = list.iter();
            while (iter.hasNext()) {
                entry = (ClassListEntry)iter.next();
                entry.resolve(list);
                String decl = null;
                decl = entry.isIFace() ? DefaultStyle.declareIFace(entry) : DefaultStyle.declareClass(entry);
                ofile.write(decl);
            }
            ofile.write("\n");
            iter = list.iter();
            while (iter.hasNext()) {
                entry = (ClassListEntry)iter.next();
                if (!entry.isIFace()) {
                    ofile.write(DefaultStyle.implement(entry.sclass(), entry.dot_name()));
                }
                for (int i = 0; i < entry.numIFaces(); ++i) {
                    ofile.write(DefaultStyle.iface(entry.printIFace(i), entry.dot_name()));
                }
            }
            ofile.write("\n" + DefaultStyle.copyleft() + "}\n");
            ofile.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

