/*
 * Decompiled with CFR 0.152.
 */
package DotClass;

import DotClass.ClassList;
import ReflWrap.ClassInfo;
import java.util.StringTokenizer;

public class ClassListEntry {
    private ClassInfo cinfo;
    private String name;
    private String dot_name;
    private String sclass;
    private String[] ifaces;

    public ClassListEntry(ClassInfo cinfo) {
        this.cinfo = cinfo;
        this.name = cinfo.fqcn();
        this.dot_name = this.genDotName();
        this.sclass = null;
        this.ifaces = null;
    }

    public String name() {
        return this.name;
    }

    public String dot_name() {
        return this.dot_name;
    }

    private String genDotName() {
        StringTokenizer str = new StringTokenizer(this.name, ".");
        String Name = null;
        while (str.hasMoreTokens()) {
            Name = str.nextToken();
        }
        return Name.toLowerCase();
    }

    public String toString() {
        return this.name + ", Superclass: " + this.sclass + ", Interfaces: " + this.printIFaces();
    }

    public String printIFaces() {
        if (this.ifaces == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.ifaces.length; ++i) {
            buf.append(this.printIFace(i) + " ");
        }
        return buf.toString();
    }

    public boolean isIFace() {
        return this.sclass == null;
    }

    public String printIFace(int i) {
        return this.ifaces[i];
    }

    public int numIFaces() {
        if (this.ifaces == null) {
            return 0;
        }
        return this.ifaces.length;
    }

    public String sclass() {
        return this.sclass;
    }

    public void resolve(ClassList list) {
        if (this.cinfo.sclass() != null) {
            this.sclass = list.find(this.cinfo.fqsuperclass(), false);
        }
        this.ifaces = new String[this.cinfo.interfaces().length];
        for (int i = 0; i < this.cinfo.interfaces().length; ++i) {
            this.ifaces[i] = list.find(this.cinfo.interfaces()[i].getName(), false);
        }
    }
}

