/*
 * Decompiled with CFR 0.152.
 */
package CodeGen;

import CTL.Annotate.const_;
import CTL.Annotate.dont;
import ReflWrap.ClassInfo;
import ReflWrap.MethodInfo;
import java.lang.reflect.Method;
import java.util.LinkedList;

public class Methode {
    private ClassInfo cinfo;
    private Method meth;
    private MethodInfo minfo;
    private boolean _const = false;

    public Methode(ClassInfo cinfo, Method meth) {
        this.cinfo = cinfo;
        this.meth = meth;
        this.minfo = new MethodInfo(meth);
        if (cinfo != null) {
            this._const = cinfo.isAnot(const_.class);
        }
    }

    public boolean _const() {
        return this._const;
    }

    public boolean dont() {
        return this.meth.isAnnotationPresent(dont.class);
    }

    public int len() {
        return this.minfo.params().length;
    }

    public boolean here() {
        return this.minfo._class() == this.cinfo._class();
    }

    public boolean isVoid() {
        return this.minfo.returns().name().equals("void");
    }

    public boolean isStatic() {
        return this.minfo.isStatic();
    }

    public String head(boolean isrResult) {
        if (isrResult) {
            return this.minfo.modifiersToString() + (this.isVoid() ? "void " : "rResult ") + this.minfo.name() + "_rr (" + this.minfo.paramsToString();
        }
        return this.minfo.toString();
    }

    public String name() {
        return this.minfo.name();
    }

    public String modifiers() {
        return this.minfo.modifiersToString();
    }

    public String params() {
        return this.minfo.paramsToString();
    }

    public String returns() {
        return this.minfo.returns().name();
    }

    public String returnsT() {
        return this.minfo.returnsT();
    }

    public MethodInfo minfo() {
        return this.minfo;
    }

    public static Methode[] fetchAll(ClassInfo cinfo) {
        LinkedList<Methode> list = new LinkedList<Methode>();
        for (Method m : cinfo.methods()) {
            if (m == null) {
                list.add(null);
                continue;
            }
            list.add(new Methode(cinfo, m));
        }
        Methode[] ret = new Methode[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Methode)list.get(i);
        }
        return ret;
    }
}

