/*
 * Decompiled with CFR 0.152.
 */
package CodeGen;

import CTL.RUtil;
import CodeGen.Konstruktor;
import CodeGen.Methode;
import ReflWrap.ByteCode;
import ReflWrap.ClassInfo;
import ReflWrap.MethodInfo;
import ReflWrap.Refl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public abstract class Gen {
    public ClassInfo cinfo;
    protected Konstruktor[] constr;
    protected Methode[] methods;
    protected String name;
    protected String pkg;
    protected String prfx;
    protected String supername;
    protected String modifiers = "";
    protected boolean isForwardDecl = false;
    protected boolean isCTLI = false;

    public Gen(String klass) throws ClassNotFoundException {
        this("javaSys", klass);
    }

    public Gen(String pkg, String klass) throws ClassNotFoundException {
        this.pkg = pkg;
        this.cinfo = new ClassInfo(Class.forName(klass));
        this.constr = Konstruktor.fetchAll(this.cinfo);
        this.methods = Methode.fetchAll(this.cinfo);
        if (this.cinfo._package().equals("_default")) {
            this.pkg = "_default";
        }
        this.prfx = this.pkg.equals("_default") ? "" : this.pkg + "::";
    }

    protected static void writeTo(OutputStreamWriter out, String str) throws IOException {
        out.write(str, 0, str.length());
    }

    protected static String classNameToDotJavaFile(String klas) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer str = new StringTokenizer(klas, ".");
        while (str.hasMoreTokens()) {
            buf.append(str.nextToken() + (str.hasMoreTokens() ? "/" : ""));
        }
        buf.append(".java");
        return "src/" + buf.toString();
    }

    protected static void getImports(StringBuffer buf, String klas) {
        try {
            FileReader fin = new FileReader(Gen.classNameToDotJavaFile(klas));
            LineNumberReader lin = new LineNumberReader(fin);
            String line = lin.readLine();
            while (line != null) {
                if (line.length() > 5 && line.substring(0, 6).equals("import")) {
                    buf.append(line + "\n");
                }
                line = lin.readLine();
            }
            fin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static String getImports(String klas) {
        StringBuffer buf = new StringBuffer();
        Gen.getImports(buf, klas);
        return buf.toString();
    }

    protected static void prettyPrint(File file) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec("astyle " + file.toString());
            if (proc.waitFor() == 0) {
                File orig = new File(file.toString() + ".orig");
                orig.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String classNamer(ClassInfo cinfo, String suffix) {
        String name = cinfo.name();
        if (ByteCode.matches(name, ".*CTLI$")) {
            this.isCTLI = true;
            return name.substring(0, name.length() - 4);
        }
        if (ByteCode.matches(name, ".*ForwardDecl")) {
            this.isForwardDecl = true;
            return name.substring(0, name.length() - "ForwardDecl".length()) + suffix;
        }
        return name + suffix;
    }

    protected boolean isCC() {
        String foo = this.classNamer(this.cinfo, "RI");
        String bar = this.classNamer(this.cinfo, "CI");
        return foo.equals(bar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate() throws IOException, NoSuchMethodException {
        FileOutputStream fos = null;
        try {
            File gen;
            File impl = new File(this.cinfo.filename());
            String fname = this.pkg + "/" + this.name + ".java";
            if (new File("src").exists()) {
                fname = "src/" + fname;
            }
            if (!new File("src/" + this.pkg).exists()) {
                if (new File("src").exists()) {
                    new File("src/" + this.pkg).mkdir();
                } else {
                    new File(this.pkg).mkdir();
                }
            }
            File ri = new File(fname);
            if (impl.lastModified() < ri.lastModified() && (gen = new File("src/CodeGen/GenRI.java")).lastModified() < ri.lastModified()) {
                return;
            }
            ri.delete();
            fos = new FileOutputStream(ri);
            OutputStreamWriter ostr = new OutputStreamWriter(fos);
            this.gen(ostr);
            ostr.flush();
            Gen.prettyPrint(ri);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    protected void gen(OutputStreamWriter ostr) throws IOException, NoSuchMethodException {
        Gen.writeTo(ostr, this.genHead());
        Gen.writeTo(ostr, this.genConstructors());
        Gen.writeTo(ostr, this.genWrappers());
        Gen.writeTo(ostr, this.genAccept());
        Gen.writeTo(ostr, "}\n");
    }

    protected String genHead() throws IOException {
        StringBuffer ret = new StringBuffer();
        ret.append("package " + this.pkg + ";\n\n");
        ret.append("import CTL.*;\n");
        ret.append("import CTL.CCompat.*;\n");
        ret.append("import CTL.Comm.*;\n");
        ret.append("import CTL.Streams.*;\n");
        ret.append("import CTL.Types.*;\n");
        ret.append("import ReflWrap.*;\n\n");
        ret.append("import java.io.*;\n");
        ret.append("import java.net.*;\n");
        ret.append("import java.lang.reflect.*;\n");
        ret.append("import java.util.*;\n");
        if (this.cinfo._package().equals("")) {
            System.err.println("Implementation belongs to no package.");
            System.exit(10);
        } else {
            ret.append("import " + this.cinfo._package() + ".*;\n");
        }
        Gen.getImports(ret, this.cinfo.fqcn());
        ret.append("\n/* This class was autogenerated by the CTL4j code generator from\n *\t\t" + this.getFQCN() + ".\n * Written by Boris" + " Buegling, licensed under the GNU General Public license. */\n");
        ret.append("public " + this.modifiers + " class " + this.name + " extends " + this.supername + "\n{\n");
        ret.append("public String getBase ()\n{\n");
        ret.append("return \"" + this.getFQCN() + "\";\n}\n");
        return ret.toString();
    }

    protected static String[] genValue(String retVal) {
        String[] ret = new String[2];
        Class foo = Refl.getClass(Refl.convert(retVal));
        if (retVal.equals("Array")) {
            retVal = "Object";
        }
        ret[1] = "";
        if (retVal != null && foo == null) {
            ret[1] = "(" + retVal + ")";
            retVal = "Object";
        }
        ret[0] = retVal + "Value";
        return ret;
    }

    protected String genAccept() throws IOException {
        String foo = this.supername.equals("RI") ? this.name : this.supername;
        return "public static void accept (OIStream in, Header ohead, long objID, FID fid, int id, Env env) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, CTLException\n{\n" + foo + ".accept(in, ohead, objID, fid, id, env);\n}\n";
    }

    protected String genConstructors() throws IOException {
        StringBuffer ret = new StringBuffer();
        if (this.constr.length == 0) {
            ret.append("public " + this.name + " ()\n{\n");
            if (!this.supername.equals("RI")) {
                ret.append("super((Object)null);\n");
            }
            ret.append("}\n");
        }
        for (Konstruktor con : this.constr) {
            ret.append("public " + this.name + " (" + con.params() + "\n{\n");
            if (!this.supername.equals("RI")) {
                ret.append("super((Object)null);\n");
            }
            ret.append("}\n");
        }
        return ret.toString();
    }

    protected String genWrappers() throws IOException, NoSuchMethodException {
        StringBuffer ret = new StringBuffer();
        for (Methode meth : this.methods) {
            if (meth == null || !meth.here() || meth.dont()) continue;
            ret.append(meth.head(false) + "\n{\n");
            if (!meth.isVoid()) {
                ret.append("return " + Refl.defaultVal(meth.returns()) + ";\n");
            }
            ret.append("}\n");
        }
        return ret.toString();
    }

    protected String linkErr() {
        return "System.out.println(\"Critical error, no matching linkage for \"+Location.linkage2str(proc().loc().linkage())+\".\");\n";
    }

    protected static String newObj(String clname, String arglist, boolean have_proc) {
        StringBuffer con = new StringBuffer();
        con.append("self = new " + clname + "(");
        if (have_proc) {
            con.append("proc");
        }
        if (!arglist.equals("")) {
            if (have_proc) {
                con.append(", ");
            }
            con.append(arglist);
        }
        con.append(");\n");
        con.append("return;\n");
        return con.toString();
    }

    protected static String newObj(String clname, String arglist) {
        return Gen.newObj(clname, arglist, true);
    }

    protected static String __putRefCount() {
        StringBuffer buf = new StringBuffer();
        buf.append("case 0:\n");
        buf.append("int arg0 = in.readInt();\n");
        buf.append("env.log.msg(Logger.ERR, \"STUB: RI.putRefCount() (Value: \"+arg0+\")\");\n");
        buf.append("break;\n");
        return buf.toString();
    }

    protected static void genArgList(StringBuffer buf, String p, int i, int j, boolean is_constr, Annotation[] anot) {
        String foo;
        String bar;
        String reader = RUtil.getReader(p).getName();
        boolean is_arr = reader.equals("readArray");
        boolean foobar = p.endsWith("[]");
        if (foobar && (bar = Gen.convertArray(foo = p.substring(0, p.length() - 2))).equals("(" + foo + "[])")) {
            foobar = false;
            is_arr = true;
        }
        if (!Refl.hasAnot("@CTL.Any()", anot) && reader.equals("readObject")) {
            reader = "serialRead";
        }
        if (is_constr) {
            buf.append("foo" + i + "[" + j + "] = ");
        } else {
            buf.append((is_arr ? "Object[]" : p) + " arg" + (is_arr ? "T" : "") + j + i + " = ");
        }
        if (!is_arr) {
            buf.append(!Refl.convert(p).equals(RUtil.reader2str(reader)) ? "(" + p + ")" : "");
        }
        if (foobar) {
            foo = p.substring(0, p.length() - 2);
            buf.append(Gen.convertArray(foo) + "(");
        }
        buf.append("in." + reader + "(");
        if (reader.equals("serialRead")) {
            String type = Refl.firstToken(p, "<");
            if (!type.equals(p)) {
                buf.append("new TypeTree(\"" + p + "\")");
            } else {
                buf.append(p + ".class");
            }
        }
        if (foobar) {
            buf.append(")");
        }
        buf.append(");\n");
        if (is_constr) {
            return;
        }
        if (is_arr) {
            buf.append(p + " arg" + j + i + " = new " + p.substring(0, p.length() - 1) + "argT" + j + i + ".length];\n");
            buf.append("for (int i=0;i<argT" + j + i + ".length;i++)\n");
            buf.append("arg" + j + i + "[i] = " + RUtil.converter(p.substring(0, p.length() - 2), "argT" + j + i + "[i]") + ";\n");
        }
    }

    protected static String newMethod(String clname, String funcname, int len, boolean returnme) {
        StringBuffer ret = new StringBuffer();
        ret.append((returnme ? "return " : "") + clname + "." + funcname + "(");
        for (int j = 0; j < len; ++j) {
            ret.append("arg" + j + (j == len - 1 ? "" : ", "));
        }
        ret.append(");\n");
        return ret.toString();
    }

    protected static String newMethod(String clname, String funcname, int len) {
        return Gen.newMethod(clname, funcname, len, true);
    }

    protected String getFQCN() {
        String name = this.cinfo.fqcn();
        if (this.isForwardDecl) {
            name = name.substring(0, name.length() - "ForwardDecl".length());
        }
        return name;
    }

    protected static String convertArray(MethodInfo minfo) {
        return Gen.convertArray(minfo.returns().arrayType().getSimpleName());
    }

    protected static String convertArray(String klass) {
        String method = klass + "Array";
        Class[] args = new Class[]{Object.class};
        try {
            Method foo = Refl.class.getDeclaredMethod(method, args);
            return "Refl." + method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return "(" + klass + "[])";
        }
    }

    protected static String arrayConversion(String type) {
        StringBuffer buf = new StringBuffer();
        buf.append("Object[] tmp = (Object[])data;\n");
        buf.append(type + "[] tmp2 = new " + type + "[tmp.length];\n");
        buf.append("for (int i=0;i<tmp.length;i++)\n");
        buf.append("tmp2[i] = (" + type + ")tmp[i];\n");
        return buf.toString();
    }
}

