/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.Comm.SSHv2;
import CTL.Env;
import CTL.Password;
import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
implements Writable {
    public static final int FILE = 0;
    public static final int SERIAL = 1;
    public static final int MPI = 2;
    public static final int LAM = 3;
    public static final int PVM = 4;
    public static final int THREAD = 5;
    public static final int TCP = 6;
    public static final int LIB = 7;
    public static final int DMN = 8;
    public static final int SSH = 9;
    public static final int PIPE = 10;
    public static final int UNDEF = 63;
    public static final int HTTP = 70;
    protected String cmd;
    protected String path;
    protected String host;
    protected int port = -1;
    public String user;
    private String pass;
    protected int linkage;

    public int linkage() {
        return this.linkage;
    }

    public static String linkage2str(int linkage) {
        switch (linkage) {
            case 0: {
                return "file";
            }
            case 1: {
                return "serial";
            }
            case 2: {
                return "mpi";
            }
            case 3: {
                return "lam";
            }
            case 4: {
                return "pvm";
            }
            case 5: {
                return "thread";
            }
            case 6: {
                return "tcp";
            }
            case 7: {
                return "lib";
            }
            case 8: {
                return "dmn";
            }
            case 9: {
                return "ssh";
            }
            case 10: {
                return "pipe";
            }
            case 70: {
                return "http";
            }
        }
        return "undef";
    }

    public String cmd() {
        return this.cmd;
    }

    public String path() {
        return this.path;
    }

    public boolean hasPassword() {
        return this.pass != null;
    }

    public void setPassword(Session sess) {
        if (this.hasPassword()) {
            sess.setPassword(this.pass);
        }
    }

    @Override
    public void read(SerialIn in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String loc = in.readString();
        this.setFromString(loc);
    }

    @Override
    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException {
        out.writeString(this.toString());
    }

    public Location(String cmd, String path, String host, int port, String user, String pass, int linkage) {
        this.cmd = cmd;
        this.path = path;
        this.host = host;
        this.port = port;
        this.user = user;
        this.pass = pass;
        this.linkage = linkage;
    }

    public Location(String cmd, String path, String host, String user, String pass, int linkage) {
        this(cmd, path, host, 22, user, pass, linkage);
    }

    public Location(String cmd, String path, String host, String user, String pass) {
        this(cmd, path, host, 22, user, pass, 6);
    }

    public Location(String cmd, String path, String host, String user, int linkage) {
        this(cmd, path, host, 22, user, Password.prompt(), linkage);
    }

    public Location(String host, int port, int linkage) {
        this(null, null, host, port, null, null, linkage);
    }

    public Location(String loc) {
        this(null, null, null, 0, null, null, 63);
        this.setFromString(loc);
    }

    public boolean isLocal() {
        return this.linkage == 7;
    }

    public void setFromString(String loc) {
        if (loc.equals("") || loc.equals("undef")) {
            return;
        }
        if (loc.startsWith("lib")) {
            this.linkage = 7;
            return;
        }
        Pattern p = Pattern.compile(" ");
        String[] foo = p.split(loc);
        String linktype = "";
        if (foo.length > 1) {
            linktype = foo[foo.length - 1];
        }
        foo[0] = loc.substring(0, loc.length() - linktype.length() - 1);
        if (linktype.equals("dmn")) {
            p = Pattern.compile(":");
            String[] bar = p.split(foo[0]);
            this.host = bar[0];
            this.port = Integer.parseInt(bar[1]);
            this.linkage = 8;
            return;
        }
        if (linktype.equals("tcp") || linktype.equals("pipe")) {
            this.linkage = linktype.equals("tcp") ? 6 : 10;
            p = Pattern.compile("@");
            Matcher m = p.matcher(foo[0]);
            if (m.find()) {
                String[] moo = p.split(foo[0]);
                foo[0] = moo[1];
                p = Pattern.compile(":");
                moo = p.split(moo[0]);
                this.user = moo[0];
                if (moo.length > 1) {
                    this.pass = moo[1];
                } else if (!SSHv2.hasPrivateKey()) {
                    this.pass = Password.prompt();
                }
            }
            p = Pattern.compile(":");
            String[] bar = p.split(foo[0]);
            this.host = bar[0];
            this.port = 22;
            p = Pattern.compile("/");
            bar[1] = foo[0].substring(bar[0].length() + 1, foo[0].length());
            foo = p.split(bar[1]);
            this.path = "";
            if (bar.length > 2) {
                this.path = this.path + foo[0];
            }
            for (int i = 1; i < foo.length - 1; ++i) {
                this.path = this.path + "/" + foo[i];
            }
            this.cmd = foo[foo.length - 1];
            return;
        }
        throw new RuntimeException("Could not parse location string '" + loc + "'.");
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.user != null) {
            ret.append(this.user);
            if (this.pass != null) {
                ret.append(":" + this.pass);
            }
            ret.append("@");
        }
        if (this.host != null) {
            ret.append(this.host);
        }
        if (this.path != null) {
            ret.append(":" + this.path);
            if (this.cmd != null) {
                ret.append("/" + this.cmd);
            }
            ret.append(" ");
        }
        ret.append(Location.linkage2str(this.linkage));
        return ret.toString();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public static LinkedList<Location> parseFile(String fname) {
        try {
            return Location.parseFile(new File(fname));
        }
        catch (IOException iOException) {
            System.out.println(System.getenv("PWD") + "/locs.txt: No such file or directory");
            Env.log.msg(2, "No resources found in '" + fname + "'.");
            Env.log.msg(5, "CWD: " + System.getenv("PWD"));
            return null;
        }
    }

    public static LinkedList<Location> parseFile(File file) throws IOException {
        LinkedList<Location> list = new LinkedList<Location>();
        BufferedReader buf = new BufferedReader(new FileReader(file));
        while (buf.ready()) {
            String line = buf.readLine();
            if (line.equals("") || line.charAt(0) == '#') continue;
            list.add(new Location(line));
        }
        buf.close();
        return list;
    }
}

