/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class IPaddr
implements Writable {
    private short[] IP = new short[8];

    public short[] rawIP() {
        return this.IP;
    }

    public void read(SerialIn in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Short[] tmp = in.__readArray(Short.TYPE, null, 8);
        for (int i = 0; i < tmp.length; ++i) {
            this.IP[i] = tmp[i];
        }
    }

    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException {
        out.__writeArray(this.IP);
    }

    public IPaddr(InetAddress in) {
        this.IP = IPaddr.getShortArray(in);
    }

    public IPaddr(long ip) throws UnknownHostException {
        this(IPaddr.setUint32(ip));
    }

    public IPaddr(String str, int i) {
        if (str == null) {
            return;
        }
        StringTokenizer token = new StringTokenizer(str, ":");
        int m = 0;
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            this.IP[m] = 0;
            for (int n = 0; n < s.length(); ++n) {
                int c = s.charAt(n);
                if ((c -= 48) > 9) {
                    c -= 7;
                }
                int n2 = m;
                this.IP[n2] = (short)((double)this.IP[n2] + (double)c * Math.pow(16.0, 3 - n));
            }
            ++m;
        }
    }

    public IPaddr(String host) throws UnknownHostException {
        this(InetAddress.getByName(host));
    }

    public IPaddr() {
        try {
            this.IP = IPaddr.getShortArray(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            try {
                this.IP = IPaddr.getShortArray(InetAddress.getByName("127.0.0.1"));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public boolean equals(IPaddr ip) {
        if (ip == null) {
            return this.toString().equals("");
        }
        return this.toString().equals(ip.toString());
    }

    public boolean equals(InetAddress ip) {
        short[] test = IPaddr.getShortArray(ip);
        for (int i = 0; i < 8; ++i) {
            if (test[i] == this.IP[i]) continue;
            return false;
        }
        return true;
    }

    public long getUint32() throws UnknownHostException {
        return IPaddr.getUint32(IPaddr.setShortArray(this.IP));
    }

    public static long getUint32(InetAddress ip) {
        if (ip == null) {
            return -1L;
        }
        byte[] adr = ip.getAddress();
        long[] i = new long[4];
        for (int j = 0; j < 4; ++j) {
            i[j] = adr[j] < 0 ? 256 + adr[j] : adr[j];
        }
        return i[3] + (i[2] << 8) + (i[1] << 16) + (i[0] << 24);
    }

    public static InetAddress setUint32(long ip) throws UnknownHostException {
        StringBuffer buf = new StringBuffer();
        for (int i = 32; i <= 56; i += 8) {
            long t = ip << i >> 56;
            buf.append((t < 0L ? 256L + t : t) + (i == 56 ? "" : "."));
        }
        InetAddress retval = InetAddress.getByName(buf.toString());
        return retval;
    }

    public String toString() {
        try {
            byte[] adr = IPaddr.setShortArray(this.IP).getAddress();
            short[] i = new short[4];
            for (int j = 0; j < 4; ++j) {
                i[j] = (short)(adr[j] < 0 ? 256 + adr[j] : adr[j]);
            }
            return i[0] + "." + i[1] + "." + i[2] + "." + i[3];
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public InetAddress toInetAddress() throws UnknownHostException {
        return IPaddr.setShortArray(this.IP);
    }

    public static InetAddress setShortArray(short[] ip) throws UnknownHostException {
        if (ip.length != 8) {
            return null;
        }
        return IPaddr.setUint32((ip[6] << 16) + (ip[7] < 0 ? 65536 + ip[7] : ip[7]));
    }

    public static short[] getShortArray(InetAddress ip) {
        long ip2 = IPaddr.getUint32(ip);
        short[] retval = new short[8];
        retval[6] = (short)(ip2 >> 16);
        retval[7] = (short)(ip2 << 16 >> 16);
        return retval;
    }
}

