/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.Env;
import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import CTL.Types.IPaddr;
import CTL.Types.PeerID;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class GroupInfo
implements Writable {
    private PeerID pid;
    private long objID;
    private boolean wantTerm = true;

    public GroupInfo(PeerID pid, long objID) {
        this.pid = pid;
        this.objID = objID;
        if (pid != null) {
            Env.log.msg(7, "GroupInfo port set to " + pid.port() + ".");
        }
    }

    public String toString() {
        return this.pid.toString();
    }

    public void read(SerialIn in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.pid = in.serialRead(PeerID.class);
        this.objID = in.serialRead(Long.class);
        this.wantTerm = in.serialRead(Boolean.class);
    }

    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.serialWrite(this.pid);
        out.serialWrite(this.objID);
        out.serialWrite(this.wantTerm);
    }

    public IPaddr host() {
        return this.pid.host();
    }

    public int port() {
        return this.pid.port();
    }

    public PeerID pid() {
        return this.pid;
    }

    public long id() {
        return this.objID;
    }
}

