/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import CTL.Types.Node;
import CTL.Types.Reference;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class Graph
implements Writable {
    private Node[] nodes = null;
    private boolean[][] adjM = null;
    private int edges = 0;

    public Graph(int size) {
        if (size <= 0) {
            return;
        }
        this.resize(size);
    }

    public int size() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.length;
    }

    public boolean equals(Object moo) {
        return moo instanceof Graph && this.toString().equals(moo.toString());
    }

    private void resize(int size) {
        this.nodes = new Node[size];
        this.adjM = new boolean[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.adjM[i][j] = i == j;
            }
        }
    }

    public boolean addNode(Node data) {
        if (this.nodes == null) {
            this.resize(1);
            this.setNode(0, data);
            return true;
        }
        if (this.findNode(data) > -1) {
            return false;
        }
        Node[] old_nodes = this.nodes;
        boolean[][] old_adjM = this.adjM;
        this.edges = 0;
        this.resize(old_nodes.length + 1);
        for (int i = 0; i < old_nodes.length; ++i) {
            this.setNode(i, old_nodes[i]);
            for (int j = 0; j < old_nodes.length; ++j) {
                if (!old_adjM[i][j]) continue;
                this.addEdge(i, j);
            }
        }
        this.setNode(old_nodes.length, data);
        return true;
    }

    public int findNode(Node data) {
        if (data != null && this.nodes != null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!data.equals(this.nodes[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isEdge(int i, int j) {
        return this.adjM[i][j];
    }

    public int cost(int i, int j) {
        return this.nodes[i].cost() + this.nodes[j].cost();
    }

    public boolean addEdge(int i, int j) {
        if (i < 0 || j < 0 || this.adjM[i][j] || i == j || i >= this.adjM.length || j >= this.adjM[i].length) {
            return false;
        }
        this.adjM[i][j] = true;
        ++this.edges;
        return true;
    }

    public boolean addEdge2(int i, int j) {
        return this.addEdge(i, j) && this.addEdge(j, i);
    }

    public void setNode(int i, Node data) {
        this.nodes[i] = data;
    }

    public Node node(int i) {
        return this.nodes[i];
    }

    public String toString() {
        if (this.nodes == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            buf.append(this.nodes[i] + " (" + this.nodes[i].cost() + ") --> ");
            for (int j = 0; j < this.nodes.length; ++j) {
                if (i == j || !this.adjM[i][j]) continue;
                buf.append(this.nodes[j] + "  ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(this.edges);
        if (this.nodes == null) {
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            for (int j = 0; j < this.nodes.length; ++j) {
                if (i == j || !this.adjM[i][j]) continue;
                out.serialWrite(new Reference(this.nodes[i]));
                out.serialWrite(new Reference(this.nodes[j]));
            }
        }
    }

    public void read(SerialIn in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            Reference ref = (Reference)in.serialRead(Reference.class, Node.class);
            Reference ref2 = (Reference)in.serialRead(Reference.class, Node.class);
            Node n1 = (Node)ref.obj();
            Node n2 = (Node)ref2.obj();
            if (ref.first()) {
                this.addNode(n1);
            }
            if (ref2.first()) {
                this.addNode(n2);
            }
            this.addEdge(this.findNode(n1), this.findNode(n2));
        }
    }
}

