/*
 * Decompiled with CFR 0.152.
 */
package CTL.Serialize;

import CTL.Env;
import CTL.RUtil;
import CTL.Serialize.SerialIn;
import CTL.Types.CTLException;
import CTL.Types.Tupel;
import ReflWrap.TypeTree;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTLIn
extends SerialIn {
    public CTLIn(InputStream in) throws IOException {
        super(in);
    }

    public String toString() {
        String ret = "";
        try {
            ret = this.hashCode() + " -- " + this.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String readString() throws IOException {
        CharArrayWriter ch = new CharArrayWriter();
        char c = (char)this.readByte();
        while (c != '\u0000') {
            ch.write(c);
            c = (char)this.readByte();
        }
        return ch.toString();
    }

    @Override
    public String readWString() throws IOException {
        CharArrayWriter ch = new CharArrayWriter();
        char c = this.readChar();
        while (c != '\u0000') {
            ch.write(c);
            c = this.readChar();
        }
        return ch.toString();
    }

    @Override
    public <T> T[] readArray(Class<T> type, LinkedList<TypeTree> param) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int len = (int)this.readLong();
        Env.log.msg(5, "Reading array with " + len + " elements.");
        return this.__readArray(type, param, len);
    }

    @Override
    public <T> T[] __readArray(Class<T> type, LinkedList<TypeTree> param, int len) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (len == 0) {
            return null;
        }
        Method m = RUtil.serialrd2;
        Object[] args = new Object[]{new TypeTree(type, param)};
        Object[] arr = new Object[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = m.invoke((Object)this, args);
            if (arr[i] != null) continue;
            Env.log.msg(2, "Arrary element is null.");
        }
        Env.log.msg(7, "CTLIn.readArray(): " + Arrays.toString(arr));
        return arr;
    }

    @Override
    public Tupel readTupel(Class[] types) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CTLException {
        if (types == null) {
            return null;
        }
        Tupel ret = new Tupel(types);
        ret.read(this);
        return ret;
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String klass = this.readString();
        if (klass.equals("")) {
            return null;
        }
        Class toread = Env.AnyObjIdent.get(klass);
        Env.log.msg(4, "Read an object of class " + toread.getName());
        this.readInt();
        return this.serialRead(toread);
    }
}

