/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Comm.BuffyIn;
import CTL.Comm.BuffyOut;
import CTL.Comm.Communicator;
import CTL.Comm.TCPCommunicator;
import CTL.Env;
import CTL.RUtil;
import CTL.Streams.IStream2;
import CTL.Types.CTLException;
import CTL.Types.Except;
import CTL.Types.FID;
import CTL.Types.GroupInfo;
import CTL.Types.Header;
import CTL.Types.IPaddr;
import CTL.Types.rPointer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Remote {
    public static final String magic = "1F3E:A28E:2CF0:9378:AA01:0744:5D31:710A";
    public static final int magic2 = 496110927;
    public static final int EOC = -1;
    public static final int DAT = 1;
    public static final int OPER = 2;
    public static final int RMI = 3;
    public static final int CTRL = 4;
    public static final int ERR = 5;
    public static final int SSH = 20;
    public static final int DBG = 21;
    public static final int UNDEF = 255;
    public static final int C = 1;
    public static final int CPP = 2;
    public static final int FORTRAN = 3;
    public static final int JAVA = 4;
    private static int tag = 256;

    public static String parseMType(int mtype) {
        switch (mtype) {
            case 1: {
                return "DAT";
            }
            case 2: {
                return "OPER";
            }
            case 3: {
                return "RMI";
            }
            case 5: {
                return "ERR";
            }
            case 255: {
                return "UNDEF";
            }
            case 20: {
                return "SSH";
            }
            case 21: {
                return "DBG";
            }
        }
        return "Other";
    }

    public static Object readDAT(Communicator comm, String type) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, CTLException {
        BuffyIn in = new BuffyIn(comm.recv());
        Header head = in.i.serialRead(Header.class);
        if (head.tag() != 1) {
            String msg = "DAT expected, but " + Remote.parseMType(head.tag()) + " received.";
            Env.log.msg(2, msg);
            throw new RuntimeException(msg);
        }
        if (type.equals("HEAD")) {
            return head;
        }
        Method m = RUtil.getReader(type);
        return m.invoke((Object)in.i, (Object[])null);
    }

    public static void writeDAT(Communicator comm, Object data) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, CTLException {
        Remote.writeDAT(comm, data, comm.pid().host(), comm.pid().port());
    }

    public static void writeDAT(Communicator comm, Object data, IPaddr host, int port) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, CTLException {
        BuffyOut out = new BuffyOut();
        Header head = new Header(0L, 1, host, port, -1);
        out.o.serialWrite(head);
        if (data != null) {
            out.o.serialWrite(data);
        }
        out.o.flush();
        comm.send(out.getBytes());
    }

    public static void writeHS(GroupInfo grp, Communicator comm) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, CTLException {
        BuffyOut out = new BuffyOut();
        Header head = new Header(29L, 2, grp);
        out.o.serialWrite(head);
        out.o.serialWrite(grp);
        out.o.flush();
        comm.send(out.getBytes());
        if (Env.debugger != null) {
            String dbg = System.getenv("CTL_DBG");
            if (dbg == null) {
                dbg = "jdb";
            }
            out = new BuffyOut();
            head = new Header(9 + dbg.length(), 21, grp);
            out.o.serialWrite(head);
            out.o.writeString(dbg);
            out.o.writeInt(Env.debugID);
            out.o.writeInt(4);
            out.o.flush();
            Remote.writeDBG(comm, out.getBytes());
        }
    }

    public static void writeDBG(Communicator comm, byte[] data) {
        if (comm instanceof TCPCommunicator) {
            try {
                ((TCPCommunicator)comm).sendDebug(data);
                return;
            }
            catch (Exception e) {
                RUtil.except(e);
            }
        }
        Env.log.msg(2, "Debugging only possible for TCP connections.");
        System.exit(6);
    }

    public static GroupInfo readHS(Communicator comm) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, CTLException {
        BuffyIn in = new BuffyIn(comm.recv());
        in.i.serialRead(Header.class);
        GroupInfo ret = in.i.serialRead(GroupInfo.class);
        return ret;
    }

    private static void __call(Communicator comm, Header head, long objID, FID fid, IStream2 args, rPointer objID2, boolean keep_args) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        BuffyOut out = new BuffyOut();
        out.o.serialWrite(head);
        out.o.writeLong(objID);
        out.o.serialWrite(fid);
        if (args != null) {
            args.flush();
            args.writeToStream(out.o, keep_args);
        }
        out.o.serialWrite(objID2);
        out.o.writeInt(tag);
        out.o.flush();
        comm.send(out.getBytes(), head.size());
    }

    public static void call(Communicator comm, Header head, long objID, FID fid, IStream2 args, rPointer objID2) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        if (comm == null || head == null || fid == null || objID2 == null) {
            Env.log.msg(2, "Critical Error: Null argument.");
            return;
        }
        int argsz = args != null ? args.streamSize() : 0;
        head.setSize(8 + fid.size() + argsz + objID2.size() + 4);
        if (args != null) {
            args.flush();
        }
        Env.log.msg(5, ".:. RMI call .:.");
        Env.log.msg(5, "\tHeader: " + head);
        Env.log.msg(5, "\tObjID: " + objID);
        Env.log.msg(5, "\tFID: " + fid);
        Env.log.msg(5, "\tArguments (" + argsz + "): " + args);
        Env.log.msg(5, "\trResult: " + objID2);
        Env.log.msg(5, "\tTag: " + tag);
        if (args != null) {
            args.flush();
        }
        Remote.__call(comm, head, objID, fid, args, objID2, false);
        ++tag;
    }

    public static void answer(Communicator comm, Header head, long objID, Except ex, IStream2 args) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        if (comm == null || head == null || ex == null) {
            Env.log.msg(2, "Critical Error: Null argument.");
            return;
        }
        int argsz = args != null ? args.streamSize() : 0;
        head.setSize(8 + ex.size() + argsz);
        if (args != null) {
            args.flush();
        }
        Env.log.msg(5, ".:. RMI answer .:.");
        Env.log.msg(5, "\tHeader: " + head);
        Env.log.msg(5, "\tObjID: " + objID);
        Env.log.msg(5, "\tException: " + ex);
        Env.log.msg(5, "\tArguments (" + argsz + "): " + args);
        if (args != null) {
            args.flush();
        }
        Remote.__answer(comm, head, objID, ex, args, false);
    }

    private static void __answer(Communicator comm, Header head, long objID, Except ex, IStream2 args, boolean keep_args) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        BuffyOut out = new BuffyOut();
        out.o.serialWrite(head);
        out.o.writeLong(objID);
        out.o.serialWrite(ex);
        if (args != null) {
            args.flush();
            args.writeToStream(out.o, keep_args);
        }
        out.o.flush();
        comm.send(out.getBytes(), head.size());
    }
}

