/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Cleaner;
import CTL.Comm.BuffyOut;
import CTL.Comm.Communicator;
import CTL.Comm.SSHv2;
import CTL.Env;
import CTL.Group;
import CTL.RUtil;
import CTL.Remote;
import CTL.Streams.IStream2;
import CTL.Timer;
import CTL.Types.FID;
import CTL.Types.Header;
import CTL.Types.Location;
import CTL.Types.PeerID;
import CTL.Types.rPointer;
import java.net.SocketException;
import java.util.StringTokenizer;

public class Process {
    protected Location loc;
    private Env env = null;
    private Thread thr = null;
    private Timer t = new Timer();
    private boolean daemon = false;
    private int remote_id = -1;
    private boolean needsCleaner = true;

    public int ID() {
        return this.remote_id;
    }

    public Process(Location loc) {
        this(loc, null);
    }

    public Process(Location loc, String[] args) {
        int port = 0;
        this.env = Env.newEnv();
        this.loc = loc;
        if (loc == null) {
            Env.log.msg(3, "Location is empty.");
            return;
        }
        if (loc.linkage() == 7) {
            return;
        }
        String debug = System.getenv("CTL_DEBUGGER");
        String debugger = System.getenv("CTL_DBG");
        if (debug != null) {
            try {
                StringTokenizer tok = new StringTokenizer(debug, ":");
                Env.debugger = new PeerID(tok.nextToken(), Integer.parseInt(tok.nextToken()));
            }
            catch (Exception e) {
                RUtil.except(e);
            }
        }
        if (args != null && args.length >= 1) {
            for (String arg : args) {
                if (!arg.startsWith("-L")) continue;
                try {
                    StringTokenizer tok = new StringTokenizer(arg, " ");
                    tok.nextToken();
                    port = Integer.parseInt(tok.nextToken());
                }
                catch (Exception e) {
                    RUtil.except(e);
                }
            }
        }
        try {
            if (loc.path() == null) {
                this.remote_id = 0;
                this.env.grp = new Group(loc.host(), loc.port(), 1, 2, loc.linkage(), this.env);
                this.daemon = true;
            } else {
                this.remote_id = 1;
                this.env.grp = new Group(loc.host(), loc.port(), 0, 2, loc.linkage(), port, this.env);
                this.startService(loc, this.env.comm[this.remote_id]);
                this.env.comm[this.remote_id].accept();
                this.env.grp.writeVersion(this.env.comm[this.remote_id]);
                this.env.grp.HS_recv();
                Env.log.msg(4, "Service started in " + Timer.timestr(this.t.stop2()) + " seconds");
            }
            Thread thr = new Thread(this.env.grp);
            thr.start();
            while (!this.env.grp.running()) {
            }
        }
        catch (Exception e) {
            RUtil.except(e);
            throw new RuntimeException("Could not create link.");
        }
        if (this.needsCleaner) {
            this.needsCleaner = false;
            Cleaner cl = new Cleaner(Thread.currentThread());
            cl.start();
        }
        Env.procs.add(this);
    }

    public boolean isAlive() {
        if (this.thr != null) {
            return this.thr.isAlive();
        }
        return true;
    }

    private void startService(Location loc, Communicator comm) {
        SSHv2 cli = new SSHv2(loc, comm, this.env);
        this.thr = new Thread(cli);
        this.thr.start();
    }

    public void stopService() {
        this.stopService(this.ID(), this.daemon);
    }

    public void stopService(int you, boolean dmn) {
        block5: {
            try {
                if (dmn) {
                    BuffyOut out = new BuffyOut();
                    Header head = new Header(0L, -1, this.env.grp.myInfo());
                    out.o.serialWrite(head);
                    out.o.flush();
                    this.env.comm[you].send(out.getBytes());
                } else {
                    if (this.env.grp == null) {
                        return;
                    }
                    Header head = new Header(0L, 3, this.env.grp.myInfo());
                    FID fid = new FID(3, "");
                    IStream2 args = new IStream2();
                    args.write(this.env.grp.myInfo().pid());
                    args.write("EOF.");
                    this.env.grp.terminate();
                    Env.log.msg(7, "Terminating remote service.");
                    Remote.call(this.env.comm[you], head, this.env.grp.grp[you].id(), fid, args, new rPointer(0L, this.env.grp.myInfo()));
                }
                this.env.comm[you].close();
            }
            catch (Exception e) {
                if (e instanceof SocketException) break block5;
                e.printStackTrace();
            }
        }
        this.t.stop();
        Env.clean = true;
        Env.procs.remove(this);
    }

    public Location loc() {
        return this.loc;
    }

    public Env getEnv() {
        return this.env;
    }

    public String toString() {
        return this.loc.toString();
    }
}

