/*
 * Decompiled with CFR 0.152.
 */
package CTL.Comm;

import CTL.Comm.BuffyIn;
import CTL.Comm.Communicator;
import CTL.Env;
import CTL.RUtil;
import CTL.Streams.OIStream;
import CTL.Types.CTLException;
import CTL.Types.Header;
import CTL.Types.IPaddr;
import CTL.Types.PeerID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.Selector;

public class TCPCommunicator
extends Communicator {
    private IPaddr host = null;
    private int port = 0;
    private Selector sel = null;
    private Socket sock = null;
    private Socket dbgsock = null;
    private ServerSocket ssock = null;

    public void setHost(IPaddr host) {
        this.host = host;
    }

    public TCPCommunicator() {
        try {
            this.sel = Selector.open();
        }
        catch (IOException e) {
            RUtil.except(e);
        }
        this.host = new IPaddr();
    }

    public TCPCommunicator(String host, int port, int lport) {
        this();
        this.host = TCPCommunicator.determineIP(host, port);
        this.port = lport;
    }

    public TCPCommunicator(int port) {
        this();
        this.port = port;
    }

    public void accept() throws IOException {
        this.sock = this.ssock.accept();
        this.host = new IPaddr(this.sock.getLocalAddress());
    }

    public void listen() throws IOException {
        this.ssock = new ServerSocket(this.port, 25);
        this.port = this.ssock.getLocalPort();
        Env.log.msg(6, "Listening on " + this.ssock.getLocalPort() + ".");
    }

    public PeerID pid() {
        Env.log.msg(7, "" + this.port);
        return new PeerID(this.host, this.port);
    }

    public void connect(PeerID pid) throws UnknownHostException, IOException {
        this.sock = new Socket(pid.host().toString(), pid.port());
        this.host = new IPaddr(this.sock.getLocalAddress());
        this.port = this.sock.getLocalPort();
    }

    private void attachDebugger(PeerID dbgHost) throws UnknownHostException, IOException {
        if (dbgHost == null) {
            Env.log.msg(2, "Can not attach NULL debugger.");
            return;
        }
        String host = dbgHost.host().toString();
        int port = dbgHost.port();
        this.dbgsock = new Socket(host, port);
        Env.log.msg(5, "Debugger attached from " + host + ":" + port + "\n");
    }

    public void close() throws IOException {
        this.sock.close();
        if (this.dbgsock != null) {
            this.dbgsock.close();
        }
    }

    public void send(byte[] data, long len, boolean debug) throws IOException {
        if (debug && Env.debugger != null) {
            this.sendDebug(data);
            try {
                OIStream in = new OIStream(this.dbgsock.getInputStream());
                Header head = in.serialRead(Header.class);
            }
            catch (Exception e) {
                Env.log.msg(2, "Read error");
                RUtil.except(e);
            }
        }
        OutputStream out = this.sock.getOutputStream();
        Env.log.msg(4, "Writing " + (data.length - 38) + " bytes.");
        out.write(data);
        out.flush();
    }

    public void sendDebug(byte[] data) throws IOException {
        if (this.dbgsock == null) {
            this.attachDebugger(Env.debugger);
        }
        OutputStream out = this.dbgsock.getOutputStream();
        out.write(data);
        out.flush();
    }

    public byte[] recv(long len) throws IOException, CTLException {
        InputStream inp = this.sock.getInputStream();
        new OIStream(inp);
        byte[] buf = new byte[(int)len];
        inp.read(buf);
        return buf;
    }

    public byte[] recv() throws IOException, CTLException {
        try {
            int i;
            int headN = RUtil.objSize(new Header());
            InputStream inp = this.sock.getInputStream();
            byte[] buf = new byte[headN];
            inp.read(buf);
            if (buf == null) {
                Env.log.msg(2, "No data received.");
            }
            BuffyIn in = new BuffyIn(buf);
            Header head = in.i.serialRead(Header.class);
            if (head == null) {
                Env.log.msg(2, "Empty header.");
                return null;
            }
            if (head.getSize() > 0x4000000L) {
                Env.log.msg(2, "Header size larger than 64MB.");
                System.out.println("Possible header corruption detected.");
                System.exit(11);
            }
            byte[] buf2 = new byte[(int)head.getSize()];
            Env.log.msg(4, "Read " + head.getSize() + " bytes.");
            inp.read(buf2);
            byte[] buf3 = new byte[(int)head.getSize() + headN];
            for (i = 0; i < headN; ++i) {
                buf3[i] = buf[i];
            }
            for (i = 0; i < (int)head.getSize(); ++i) {
                buf3[headN + i] = buf2[i];
            }
            Env.log.msg(7, "recv() Header: " + head);
            return buf3;
        }
        catch (IllegalAccessException e0) {
        }
        catch (ClassNotFoundException e1) {
        }
        catch (InvocationTargetException e2) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public static IPaddr determineIP(String host, int port) {
        try {
            Socket sock = new Socket(host, port);
            IPaddr ret = new IPaddr(sock.getLocalAddress());
            Env.log.msg(5, "" + ret);
            sock.close();
            return ret;
        }
        catch (IOException e) {
            return null;
        }
    }
}

