/*
 * Decompiled with CFR 0.152.
 */
package CTL.Comm;

import CTL.Comm.Communicator;
import CTL.Comm.TCPCommunicator;
import CTL.Env;
import CTL.Types.IPaddr;
import CTL.Types.PeerID;
import Hitman.HTTP.Request;
import Hitman.HURL;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class HTTPCommunicator
extends Communicator {
    private static ServerSocket ssock = null;
    private static IPaddr host = null;
    private static int port = -1;
    private HURL url = null;
    private byte[] content = null;

    public void setPort(int port) {
        HTTPCommunicator.port = port;
    }

    public HTTPCommunicator(String u) {
        this.url = new HURL(u);
        host = TCPCommunicator.determineIP(this.url.host(), this.url.port());
    }

    public HTTPCommunicator() {
    }

    public void listen() throws IOException {
        ssock = new ServerSocket(port == -1 ? 0 : port, 25);
        port = ssock.getLocalPort();
        Env.log.msg(6, "Listening on " + ssock.getLocalPort() + ".");
    }

    public PeerID pid() {
        return new PeerID(host, port);
    }

    public void connect(PeerID pid) throws UnknownHostException, IOException {
        this.url = new HURL("http://" + pid.host() + ":" + pid.port());
    }

    public void accept() throws IOException {
        Socket sock = ssock.accept();
        new Request(sock);
    }

    public void close() throws IOException {
    }

    public void send(byte[] data, long len, boolean debug) throws IOException {
        Request req = new Request(this.url, Request.Type.POST, data.toString(), "application/ctl");
        req.send(true);
        this.content = req.getReply();
    }

    public byte[] recv(long len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }

    public byte[] recv() throws IOException {
        if (this.content != null) {
            byte[] ret = this.content;
            this.content = null;
            return ret;
        }
        Socket sock = ssock.accept();
        Request req = new Request(sock);
        req.recv();
        return req.getReply();
    }
}

