/*
 * Decompiled with CFR 0.152.
 */
package Tools;

public class HexDumper {
    private byte[] bytes;

    public HexDumper(byte[] bytes) {
        this.bytes = bytes;
    }

    public HexDumper(String str) {
        this.bytes = str.getBytes();
    }

    public String toString() {
        return this.convert();
    }

    public String convert() {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < this.bytes.length; ++i) {
            if (i % 16 == 0) {
                buf.append(HexDumper.lineNumber(i / 16 + 1, 8) + " ");
            }
            buf.append(HexDumper.byteToHex(this.bytes[i]));
            this.bytes[i] = HexDumper.cleanByte(this.bytes[i]);
            if ((i + 1) % 16 == 0) {
                buf.append("  " + new String(this.bytes, i - 15, 16) + System.getProperty("line.separator"));
                continue;
            }
            buf.append(" ");
        }
        for (int j = 0; j < 49 - i % 16 * 3; ++j) {
            buf.append(" ");
        }
        buf.append(new String(this.bytes, this.bytes.length - i % 16, i % 16));
        return buf.toString();
    }

    public static byte cleanByte(byte b) {
        if (b > 6 && b < 14) {
            return 46;
        }
        return b;
    }

    public static String lineNumber(int i, int w) {
        int b = 0;
        for (int a = i; a != 0; a /= 2) {
            ++b;
        }
        byte[] ln = new byte[b--];
        String align = "";
        if (b < w) {
            StringBuffer buf = new StringBuffer();
            for (int j = 1; j < w - b; ++j) {
                buf.append("0");
            }
            align = buf.toString();
        }
        while (i != 0) {
            ln[b--] = new Integer(i % 2 + 48).byteValue();
            i /= 2;
        }
        return align + new String(ln);
    }

    public static String byteToHex(byte beit) {
        int[] hex = new int[]{beit & 0xF, (beit & 0xF0) / 16};
        return HexDumper.intToHex(hex[1]) + "" + HexDumper.intToHex(hex[0]);
    }

    public static char intToHex(int hbyte) {
        if (hbyte < 10) {
            return (char)(hbyte + 48);
        }
        return (char)(hbyte + 55);
    }

    public static void main(String[] args) {
        HexDumper dump = new HexDumper("AAAAAAAAAAAAAAAAFGH \n");
        System.out.println(dump.convert());
    }
}

