/*
 * Decompiled with CFR 0.152.
 */
package ReflWrap;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeTree {
    private Class klasse;
    private LinkedList<TypeTree> targs = new LinkedList();

    public Class klasse() {
        return this.klasse;
    }

    public LinkedList<TypeTree> targs() {
        return this.targs;
    }

    private String substr(String str, int start, int end) {
        if (end == -1) {
            return str;
        }
        return str.substring(start, end);
    }

    public Class getType() {
        return this.klasse;
    }

    public LinkedList<TypeTree> getTypeParameters() {
        return this.targs;
    }

    public TypeTree[] getTypeArray() {
        TypeTree[] ret = new TypeTree[this.targs.size()];
        int i = 0;
        for (TypeTree t : this.targs) {
            ret[i++] = t;
        }
        return ret;
    }

    public TypeTree(Class ... args) throws ClassNotFoundException {
        this(TypeTree.classify(args));
    }

    public TypeTree(Class klass, TypeTree tree) {
        this.klasse = klass;
        if (tree != null) {
            this.targs.add(tree);
        }
    }

    public TypeTree(Class klass, LinkedList<TypeTree> tree) {
        this.klasse = klass;
        if (tree != null) {
            this.targs = tree;
        }
    }

    public static String classify(Class[] args) {
        if (args.length == 1) {
            return args[0].getName();
        }
        String arg = args[0].getName() + "<";
        for (int i = 1; i < args.length; ++i) {
            arg = arg + args[i].getName() + ",";
        }
        return arg.substring(0, arg.length() - 1) + ">";
    }

    public TypeTree(String type) throws ClassNotFoundException {
        int idx = type.indexOf("<");
        String klass = this.substr(type, 0, idx);
        if (klass.equals("boolean")) {
            klass = "java.lang.Boolean";
        }
        if (klass.equals("byte")) {
            klass = "java.lang.Byte";
        }
        if (klass.equals("char")) {
            klass = "java.lang.Character";
        }
        if (klass.equals("double")) {
            klass = "java.lang.Double";
        }
        if (klass.equals("float")) {
            klass = "java.lang.Float";
        }
        if (klass.equals("int")) {
            klass = "java.lang.Integer";
        }
        if (klass.equals("long")) {
            klass = "java.lang.Long";
        }
        if (klass.equals("short")) {
            klass = "java.lang.Short";
        }
        this.klasse = Class.forName(klass);
        if (idx == -1) {
            return;
        }
        String rest = type.substring(idx + 1, type.lastIndexOf(">"));
        int end = 0;
        while (end != -1) {
            end = rest.indexOf(",");
            String cur = this.substr(rest, 0, end);
            if (cur.indexOf("<") != -1) {
                end = rest.indexOf(">");
                cur = this.substr(rest, 0, end++) + ">";
            }
            TypeTree tree = new TypeTree(cur);
            this.targs.add(tree);
            if (end >= rest.length()) break;
            rest = rest.substring(end + 1, rest.length());
        }
    }

    public String toString() {
        if (this.targs.size() == 0) {
            return this.klasse.getName();
        }
        String ret = this.klasse.getName() + "<";
        for (TypeTree t : this.targs) {
            ret = ret + t + ",";
        }
        return ret.substring(0, ret.length() - 1) + ">";
    }

    public boolean equals(String type) {
        return this.toString().equals(type);
    }

    public static void main(String[] args) {
        try {
            String type = "java.util.LinkedList<java.lang.Byte,java.lang.Boolean,java.lang.Byte<java.lang.Class,java.util.HashMap>,java.lang.Double>";
            TypeTree tree = new TypeTree(type);
            assert (tree.equals(type));
            type = "java.lang.Class";
            tree = new TypeTree(type);
            assert (tree.equals(type));
            type = "java.lang.Class<java.lang.Byte,java.lang.Integer,java.lang.Boolean>";
            tree = new TypeTree(Class.class, Byte.class, Integer.class, Boolean.class);
            assert (tree.equals(type));
            tree = new TypeTree(Byte.class, Integer.class, Boolean.class);
            tree = new TypeTree(Class.class, tree);
            assert (tree.equals(type));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

