/*
 * Decompiled with CFR 0.152.
 */
package ReflWrap;

import ReflWrap.ByteCode;
import ReflWrap.ClassInfo;
import ReflWrap.Refl;
import ReflWrap.TypeTree;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private Method m;
    private String name;
    private String[] params;

    public Class _class() {
        return this.m.getDeclaringClass();
    }

    public Method m() {
        return this.m;
    }

    public String name() {
        return this.name;
    }

    public ClassInfo returns() {
        return new ClassInfo(this.m.getReturnType());
    }

    private int determineID() {
        LinkedList<String> bcel = ByteCode.getMethods(this._class().getName());
        String method = this.toSimpleString();
        return bcel.indexOf(method);
    }

    public String returnsT() {
        TypeTree ret = ByteCode.getRetVal(this._class().getName(), this.determineID());
        return ret == null ? this.returns().name() : ret.toString();
    }

    public String[] params() {
        return this.params;
    }

    public Class[] getParams() {
        return this.m.getParameterTypes();
    }

    public MethodInfo(Method method) {
        this.m = method;
        this.name = this.m.getName();
        Type[] p = this.m.getGenericParameterTypes();
        this.params = new String[p.length];
        LinkedList<TypeTree> list = ByteCode.getParameters(this._class().getName(), this.determineID());
        for (int i = 0; i < p.length; ++i) {
            this.params[i] = list.size() > 0 ? list.get(i).toString() : Refl.printType(p[i]);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.modifiersToString());
        if (this.returns().isArray()) {
            ret.append(this.returns().arrayType().getName() + "[]");
        } else {
            ret.append(this.returnsT());
        }
        ret.append(" " + this.name + " (");
        ret.append(this.paramsToString());
        return ret.toString();
    }

    public String paramsToString() {
        int i;
        StringBuffer ret = new StringBuffer();
        for (i = 0; i < this.params.length; ++i) {
            ret.append(this.params[i] + " arg" + i + (i == this.params.length - 1 ? ")" : ", "));
        }
        if (i == 0) {
            ret.append(")");
        }
        return ret.toString();
    }

    public boolean isStatic() {
        int mod = this.m.getModifiers();
        return (mod & 8) != 0;
    }

    public String modifiersToString() {
        StringBuffer sb = new StringBuffer();
        int mod = this.m.getModifiers();
        if ((mod & 1) != 0) {
            sb.append("public ");
        }
        if ((mod & 2) != 0) {
            sb.append("private ");
        }
        if ((mod & 4) != 0) {
            sb.append("protected ");
        }
        if ((mod & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 8) != 0) {
            sb.append("static ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("final ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((mod & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((mod & 0x100) != 0) {
            sb.append("native ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((mod & 0x200) != 0) {
            sb.append("interface ");
        }
        return sb.toString();
    }

    public Annotation[] getParamAnot(int i) {
        Annotation[][] aa = this.m.getParameterAnnotations();
        return aa[i];
    }

    public <T extends Annotation> T anot(Class<T> klass) {
        return this.m.getAnnotation(klass);
    }

    public String toSimpleString() {
        String s = this.m.toString();
        s = ByteCode.sed(s, ",", ", ");
        s = ByteCode.sed(s, " arg[0-9]*", "");
        s = ByteCode.sed(s, "<.*?>", "");
        s = ByteCode.sed(s, "\\(", " ( ");
        s = ByteCode.sed(s, "\\)", ")");
        s = ByteCode.unclassify(s);
        s = ByteCode.sed(s, "\\( ", "(");
        s = ByteCode.sed(s, " \\) $", ")");
        s = ByteCode.sed(s, "\\) $", ")");
        s = ByteCode.sed(s, " throws.*", "");
        return s;
    }
}

