/*
 * Decompiled with CFR 0.152.
 */
package NCLib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    private static LinkedList<String> blacklist = new LinkedList();

    public static LinkedList<Class> getClasses() {
        LinkedList<Class> list;
        LinkedList<Class> res = new LinkedList<Class>();
        for (String pkg : Classes.getPackages()) {
            list = Classes.getClasses(pkg);
            if (list == null) continue;
            res.addAll(list);
        }
        for (String pkg : Classes.getPackagesFromClasspath()) {
            list = Classes.getClasses(pkg);
            if (list == null) continue;
            res.addAll(list);
        }
        return res;
    }

    public static LinkedList<Class> getClasses(String pkg) {
        LinkedList<Class> res = new LinkedList<Class>();
        ClassLoader.getSystemClassLoader();
        URL url = ClassLoader.getSystemResource(pkg.replace(".", "/"));
        if (url == null) {
            return null;
        }
        File dir = new File(url.getFile());
        if (dir.exists()) {
            for (String fname : dir.list()) {
                if (!fname.endsWith(".class")) {
                    if (new File(dir + "/" + fname).isDirectory()) {
                        LinkedList<Class> list = Classes.getClasses(pkg + "." + fname);
                        if (list == null) continue;
                        res.addAll(list);
                        continue;
                    }
                    if (fname.endsWith(".jar")) {
                        for (String pkg2 : Classes.getDirectoriesFromJAR(dir + "/" + fname)) {
                            LinkedList<Class> list = Classes.getClasses(pkg2);
                            if (list == null) continue;
                            res.addAll(list);
                        }
                        continue;
                    }
                }
                try {
                    String name = pkg + "." + fname.replace(".class", "");
                    if (blacklist.indexOf(name) > -1) continue;
                    Class<?> cl = Class.forName(name);
                    res.add(cl);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        } else if (url.getProtocol().equals("jar")) {
            String pkgAsFileName = pkg.replace(".", "/");
            String fname = dir.toString().replace("file:", "");
            fname = fname.substring(0, fname.indexOf("!"));
            try {
                JarFile jar = new JarFile(fname);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().toString();
                    if (!entry.startsWith(pkgAsFileName) || entry.equals(pkgAsFileName + "/") || entry.split("/").length > 1 + pkgAsFileName.split("/").length) continue;
                    if (entry.endsWith("/")) {
                        String basename = new File(entry).getName();
                        LinkedList<Class> list = Classes.getClasses(pkg + "." + basename);
                        if (list == null) continue;
                        res.addAll(list);
                        continue;
                    }
                    if (!entry.endsWith(".class")) continue;
                    try {
                        String name = entry.replace("/", ".").replace(".class", "");
                        Class<?> cl = Class.forName(name);
                        res.add(cl);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (NoClassDefFoundError e) {}
                }
            }
            catch (IOException e) {
                return res;
            }
        }
        return res;
    }

    private static LinkedList<String> getPackagesFromClasspath() {
        LinkedList<String> res = new LinkedList<String>();
        for (String element : System.getenv("CLASSPATH").split(":")) {
            if (element.endsWith(".jar")) {
                for (String fname : Classes.getDirectoriesFromJAR(element)) {
                    res.add(fname.substring(0, fname.length() - 1));
                }
                continue;
            }
            File dir = new File(element);
            if (!dir.exists()) continue;
            for (String fname : dir.list()) {
                if (!new File(dir + "/" + fname).isDirectory()) continue;
                res.add(fname);
            }
        }
        return res;
    }

    private static LinkedList<String> getDirectoriesFromJAR(String fname) {
        LinkedList<String> res = new LinkedList<String>();
        try {
            JarFile jar = new JarFile(fname);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().toString();
                if (!entry.endsWith("/") || entry.split("/").length >= 2) continue;
                res.add(entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    private static LinkedList<String> getPackages() {
        LinkedList<String> res = new LinkedList<String>();
        for (Package pkg : Package.getPackages()) {
            res.add(pkg.getName());
        }
        return res;
    }

    public static void main(String[] args) {
        System.out.println(Classes.getClasses().size());
    }

    static {
        blacklist.add("Debug.EnvDebug");
        blacklist.add("Test.TClient");
    }
}

