/*
 * Decompiled with CFR 0.152.
 */
package CTL.Streams;

import CTL.Env;
import CTL.Serialize.ASCIIOut;
import CTL.Serialize.CTLOut;
import CTL.Serialize.SerialOut;
import CTL.Streams.LittleEndian;
import CTL.Streams.OutStream;
import CTL.Types.CTLException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOStream
extends SerialOut
implements OutStream {
    private boolean swapBytes = false;
    private SerialOut stream;

    public OOStream(OutputStream out) throws IOException, CTLException {
        this(out, Serial.CTL);
    }

    public OOStream(OutputStream out, Serial type) throws CTLException, IOException {
        super(out);
        switch (type) {
            case CTL: {
                this.stream = new CTLOut(out);
                break;
            }
            case ASCII: {
                File f = new File("/tmp/ctl_out.log");
                FileOutputStream out2 = new FileOutputStream(f);
                this.stream = new ASCIIOut(out, out2);
                break;
            }
            default: {
                throw new CTLException("Serializer does not exist.");
            }
        }
    }

    public void changeEndianess(ByteOrder order) {
        this.swapBytes = order == ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public void serialWrite(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        this.stream.serialWrite(data);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void writeString(String s) throws IOException {
        this.stream.writeString(s);
    }

    @Override
    public <T> void writeArray(T data) throws IOException, IllegalAccessException, InvocationTargetException {
        this.stream.writeArray(data);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.stream.writeBytes(s);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.swapBytes) {
            v = Long.reverseBytes(v);
        }
        this.stream.writeLong(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.swapBytes) {
            v = Integer.reverseBytes(v);
        }
        this.stream.writeInt(v);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    @Override
    public void writeObject(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        this.stream.writeObject(data);
    }

    @Override
    public <T> void __writeArray(T data) throws IOException, IllegalAccessException, InvocationTargetException {
        this.stream.__writeArray(data);
    }

    @Override
    public void writeWString(String s) throws IOException {
        this.stream.writeWString(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.stream.writeUTF(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.stream.writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.swapBytes) {
            v = LittleEndian.doubleReverseBytes(v);
        }
        this.stream.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.swapBytes) {
            v = LittleEndian.floatReverseBytes(v);
        }
        this.stream.writeFloat(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.swapBytes) {
            v = Integer.reverseBytes(v);
        }
        this.stream.writeChar(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.swapBytes) {
            v = Integer.reverseBytes(v);
        }
        this.stream.writeShort(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.swapBytes) {
            v = Integer.reverseBytes(v);
        }
        this.stream.writeByte(v);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.stream.writeBoolean(v);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.swapBytes) {
            i = Integer.reverseBytes(i);
        }
        this.stream.write(i);
    }

    @Override
    protected void writeData(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        Env.log.msg(2, "Dummy method called.");
        throw new CTLException("Dummy method.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Serial {
        CTL,
        ASCII;

    }
}

