/*
 * Decompiled with CFR 0.152.
 */
package CTL.Streams;

import CTL.Env;
import CTL.RUtil;
import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Streams.OIStream;
import CTL.Streams.OOStream;
import CTL.Streams.PipedInputDream;
import CTL.Types.CTLException;
import CTL.Types.Reference;
import ReflWrap.ClassInfo;
import ReflWrap.Refl;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IStream {
    private LinkedList<Class> list;
    private SerialIn in;
    private SerialOut out;
    private int size;

    public IStream() throws IOException, CTLException {
        this.reset();
    }

    public void reset() throws IOException, CTLException {
        PipedOutputStream pout = new PipedOutputStream();
        PipedInputDream pin = new PipedInputDream(pout);
        this.out = new OOStream(pout);
        this.in = new OIStream(pin);
        this.list = new LinkedList();
        this.size = 0;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public <T> void write(T val) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        if (val == null) {
            return;
        }
        this.list.add(val.getClass());
        Object[] args = new Object[]{val};
        RUtil.serialwr.invoke((Object)this.out, args);
        this.size += RUtil.objSize(val);
    }

    public static <T> void writeType(SerialOut outp, T stuff) throws IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{stuff};
        Method m = RUtil.serialwr;
        m.invoke((Object)outp, args);
    }

    public static Object readType(SerialIn input, Class typ) throws IllegalAccessException, InvocationTargetException {
        String type = typ.getName();
        if (type.substring(0, 1).equals("[")) {
            type = Refl.type(type);
        }
        Method m = RUtil.getReader(type);
        Object[] args = null;
        if (type.charAt(type.length() - 1) == ']') {
            args = new Object[]{new ClassInfo(typ).arrayType()};
        }
        if (m.getName().equals("readObject")) {
            args = new Object[1];
            try {
                args[0] = Class.forName(type);
            }
            catch (Exception e) {
                // empty catch block
            }
            m = RUtil.serialrd;
        }
        Env.log.msg(7, "IStream.readType using " + m);
        return m.invoke((Object)input, args);
    }

    private Object readType(Class type) throws IllegalAccessException, InvocationTargetException {
        return IStream.readType(this.in, type);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        try {
            Reference.cleanup();
            LinkedList<Object> content = new LinkedList<Object>();
            LinkedList<Class> types = new LinkedList<Class>(this.list);
            for (Class clazz : this.list) {
                Object foo = this.readType(clazz);
                content.add(foo);
                if (foo != null && foo.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(foo); ++i) {
                        ret.append(Array.get(foo, i) + " ");
                    }
                } else {
                    ret.append(foo);
                }
                ret.append("\n");
            }
            if (ret.length() > 0) {
                ret.deleteCharAt(ret.length() - 1);
            }
            this.reset();
            for (Object e : content) {
                this.write(e);
            }
            this.flush();
            this.list = types;
        }
        catch (Exception e) {
            RUtil.except(e);
        }
        return ret.toString();
    }

    public void writeToStream(SerialOut ostr, boolean keep) {
        try {
            Reference.cleanup();
            LinkedList<Object> content = new LinkedList<Object>();
            LinkedList<Class> types = new LinkedList<Class>(this.list);
            for (Class clazz : this.list) {
                Object arg = this.readType(clazz);
                IStream.writeType(ostr, arg);
                if (!keep) continue;
                content.add(arg);
            }
            this.reset();
            if (keep) {
                for (Object e : content) {
                    this.write(e);
                }
            }
            this.flush();
            this.list = types;
        }
        catch (Exception e) {
            RUtil.except(e);
        }
    }

    public void writeToStream(SerialOut ostr) {
        this.writeToStream(ostr, false);
    }

    public void writeToIStream(SerialOut ostr) {
        this.writeToIStream(ostr, true);
    }

    public void writeToIStream(SerialOut ostr, boolean keep) {
        try {
            StringBuffer buf = new StringBuffer();
            for (Class c : this.list) {
                buf.append(c.getName() + "$$");
            }
            buf.delete(buf.length() - 2, buf.length());
            ostr.writeString(buf.toString());
            this.writeToStream(ostr, keep);
        }
        catch (Exception e) {
            RUtil.except(e);
        }
    }

    public void readFromStream(SerialIn istr) {
        try {
            LinkedList types = new LinkedList();
            StringTokenizer tok = new StringTokenizer(istr.readString(), "$$");
            while (tok.hasMoreTokens()) {
                String type = tok.nextToken();
                types.add(Class.forName(type));
                Class<?> moo = Class.forName(type);
                this.write(IStream.readType(istr, moo));
            }
            this.list = types;
        }
        catch (Exception e) {
            RUtil.except(e);
        }
    }

    public int streamSize() {
        return this.size;
    }
}

