/*
 * Decompiled with CFR 0.152.
 */
package CTL.Serialize;

import CTL.Env;
import CTL.RUtil;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import ReflWrap.Refl;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTLOut
extends SerialOut {
    public CTLOut(OutputStream out) throws IOException {
        super(out);
    }

    @Override
    public void writeString(String data) throws IOException {
        if (data != null) {
            this.writeBytes(data);
        }
        this.writeByte(0);
    }

    @Override
    public void writeWString(String data) throws IOException {
        if (data != null) {
            this.writeChars(data);
        }
        this.writeChar(0);
    }

    @Override
    public <T> void writeArray(T data) throws IOException, IllegalAccessException, InvocationTargetException {
        if (data == null) {
            this.writeInt(0);
            return;
        }
        this.writeLong(Array.getLength(data));
        this.__writeArray(data);
    }

    @Override
    public <T> void __writeArray(T data) throws IOException, IllegalAccessException, InvocationTargetException {
        if (data == null) {
            return;
        }
        String type = null;
        try {
            type = Array.get(data, 0).getClass().getName();
        }
        catch (NullPointerException e) {
            type = Refl.arrayType(data.getClass().getName());
        }
        Method m = RUtil.getWriter(type);
        if (m.getName().equals("writeObject")) {
            m = RUtil.serialwr;
        }
        Object[] args = new Object[1];
        for (int i = 0; i < Array.getLength(data); ++i) {
            args[0] = Array.get(data, i);
            m.invoke((Object)this, args);
        }
    }

    @Override
    public void writeObject(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        Env.log.msg(5, "writeObject() called.");
        if (data == null) {
            this.writeString("");
            return;
        }
        this.writeString(Env.AnyObjIdent.get(data.getClass()));
        this.writeInt(RUtil.objSize(data));
        this.serialWrite(data);
    }

    @Override
    protected void writeData(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        ((Writable)data).write(this);
    }
}

