/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Env;
import CTL.Streams.OIStream;
import CTL.Types.Header;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class MessageQueue {
    private HashMap<Integer, Header> map0 = new HashMap();
    private HashMap<Integer, byte[]> map1 = new HashMap();

    public void readFrom(OIStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Header head = in.serialRead(Header.class);
        byte[] payload = new byte[(int)head.getSize()];
        int r = in.read(payload);
        if (r < payload.length) {
            Env.log.msg(2, "Requested " + payload.length + " byte" + ", but only " + r + " byte could be read.");
        }
        this.enqueue(head, payload);
    }

    public void enqueue(Header head, byte[] _msg) {
        int len = _msg.length;
        if (_msg == null || len < 5) {
            return;
        }
        int tag = _msg[len - 1] + (_msg[len - 2] << 8) + (_msg[len - 3] << 16) + (_msg[len - 4] << 24);
        byte[] msg = new byte[len - 4];
        for (int i = 0; i < len - 4; ++i) {
            msg[i] = _msg[i];
        }
        this.enqueue(tag, head, msg);
    }

    public void enqueue(int tag, Header head, byte[] msg) {
        this.map0.put(tag, head);
        this.map1.put(tag, msg);
    }

    public byte[] payload(int tag) {
        byte[] ret = this.map1.get(tag);
        this.map1.remove(tag);
        return ret;
    }

    public Header header(int tag) {
        Header head = this.map0.get(tag);
        this.map0.remove(tag);
        return head;
    }

    public boolean contains(int tag) {
        return this.map0.containsKey(tag) && this.map1.containsKey(tag);
    }

    public static void main(String[] args) {
        MessageQueue msg = new MessageQueue();
        byte[] moo = new byte[]{23, 0, 0, 2, 43};
        msg.enqueue(null, moo);
        if (msg.contains(555) && msg.payload(555)[0] != 23) {
            System.exit(1);
        }
    }
}

