/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Types.CTLException;
import ReflWrap.TypeTree;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java {
    public static <T> void writeLinkedList(SerialOut out, LinkedList<T> list) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(list.size());
        for (Object o : list) {
            out.serialWrite(o);
        }
    }

    public static <T> LinkedList<T> readLinkedList(SerialIn in, TypeTree targs) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        LinkedList<Object> list = new LinkedList<Object>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            Object moo = in.serialRead(targs);
            list.add(moo);
        }
        return list;
    }

    public static void writeTypeTree(SerialOut out, TypeTree tree) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.serialWrite(tree.klasse().getName());
        out.serialWrite(tree.targs());
    }

    public static TypeTree readTypeTree(SerialIn in) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Class<?> klasse = Class.forName(in.readString());
        LinkedList targs = (LinkedList)in.serialRead(LinkedList.class, TypeTree.class);
        return new TypeTree(klasse, targs);
    }

    public static <K, V> void writeHashMap(SerialOut out, HashMap<K, V> map) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(map.size());
        for (K key : map.keySet()) {
            out.serialWrite(key);
            out.serialWrite(map.get(key));
        }
    }

    public static <K, V> HashMap<K, V> readHashMap(SerialIn in, TypeTree targs) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            Object moo = in.serialRead(targs);
            Object bar = in.serialRead(targs);
            map.put(moo, bar);
        }
        return map;
    }

    public static <E> void writeHashSet(SerialOut out, HashSet<E> set) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(set.size());
        for (E entry : set) {
            out.serialWrite(entry);
        }
    }

    public static <E> HashSet<E> readHashSet(SerialIn in, TypeTree targs) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        HashSet<Object> set = new HashSet<Object>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            Object entry = in.serialRead(targs);
            set.add(entry);
        }
        return set;
    }

    public static <E> void writeVector(SerialOut out, Vector<E> v) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(v.size());
        for (E entry : v) {
            out.serialWrite(entry);
        }
    }

    public static <E> Vector<E> readVector(SerialIn in, TypeTree targs) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Vector<Object> v = new Vector<Object>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            Object entry = in.serialRead(targs);
            v.add(entry);
        }
        return v;
    }

    public static <E> void writeStack(SerialOut out, Stack<E> stack) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(stack.size());
        Stack cloneOfMyOwn = (Stack)stack.clone();
        for (int i = 0; i < stack.size(); ++i) {
            out.serialWrite(cloneOfMyOwn.pop());
        }
    }

    public static <E> Stack<E> readStack(SerialIn in, TypeTree targs) throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Stack<Object> stack = new Stack<Object>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            Object entry = in.serialRead(targs);
            stack.push(entry);
        }
        return stack;
    }
}

