/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Comm.BuffyIn;
import CTL.Env;
import CTL.RUtil;
import CTL.Remote;
import CTL.Streams.OIStream;
import CTL.Types.CTLException;
import CTL.Types.Except;
import CTL.Types.FID;
import CTL.Types.Header;
import CTL.Types.rPointer;
import CTL.rResult;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;

public class ConnectHandler
extends Thread {
    private Env env = null;

    public ConnectHandler(Env env) {
        this.env = env;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        int conn = this.env.grp.myID() == 0 ? 1 : 0;
        try {
            this.accept(conn);
        }
        catch (Exception e) {
            if (!this.env.grp.running()) {
                return;
            }
            RUtil.except(e);
            try {
                this.env.comm[conn].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void accept(int id) throws IOException, IllegalAccessException, InvocationTargetException, CTLException, NoSuchMethodException, ClassNotFoundException, InstantiationException {
        byte[] msg = this.env.comm[id].recv();
        if (msg == null) {
            if (!this.env.grp.running()) {
                return;
            }
            if (Env.daemon) {
                return;
            }
            Env.log.msg(2, "No data received.");
        }
        BuffyIn in = new BuffyIn(msg);
        Header ohead = null;
        ohead = in.i.serialRead(Header.class);
        Env.log.msg(4, "Recv header: " + ohead);
        if (ohead.needSwap()) {
            in.changeEndianess(ByteOrder.LITTLE_ENDIAN);
        }
        switch (ohead.tag()) {
            case 2: {
                Env.log.msg(2, "OPER is not yet supported.");
                System.exit(5);
                break;
            }
            case 1: {
                Env.log.msg(2, "DAT is not yet supported.");
                System.exit(5);
                break;
            }
            case 3: {
                long objID = in.i.readLong();
                ConnectHandler.procRMI(in.i, ohead, objID, id, this.env);
                break;
            }
            case 4: {
                Env.log.msg(2, "CTRL is not yet supported.");
                System.exit(5);
                break;
            }
            default: {
                long objID = in.i.readLong();
                Env.log.msg(4, ".:. Received RMI answer .:.");
                Env.log.msg(4, "\tHeader: " + ohead);
                Env.log.msg(4, "\tObjectID: " + objID);
                Object obj = Env.map.getObj((int)objID);
                if (obj == null) {
                    Env.log.msg(2, "Object " + objID + " not found.");
                    System.exit(3);
                }
                if (!obj.getClass().getName().equals("CTL.rResult")) {
                    ConnectHandler.procRMI(in.i, ohead, objID, 1, this.env);
                    return;
                }
                Except ex = in.i.serialRead(Except.class);
                if (ex.name().length() > 0) {
                    throw new CTLException("Class not found!");
                }
                rResult res = (rResult)obj;
                for (int i = 0; i < res.results(); ++i) {
                    res.recv(in.i, i);
                }
                Env.log.msg(5, "Received rResult " + objID + ": " + res);
            }
        }
    }

    public static long argSize(Header head, FID fid) {
        return head.getSize() - 47L - (long)fid.name().length();
    }

    public static void procRMI(OIStream in, Header head, long objID, int member, Env env) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException, CTLException, InstantiationException {
        ConnectHandler.procRMI(in, head, objID, member, env, null);
    }

    public static void procRMI(OIStream in, Header head, long objID, int member, Env env, String suffix) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException, CTLException, InstantiationException {
        FID fid = in.serialRead(FID.class);
        Class targetClass = null;
        String className = fid._class();
        if (suffix != null) {
            className = fid._class(suffix);
        }
        try {
            Env.log.msg(4, "FID: ObjectID: " + objID + " - Target class: " + className);
            if (objID <= 0L) {
                targetClass = Class.forName(className);
            }
            Object req = Env.map.getObj((int)objID);
            if (req == null) {
                throw new ClassNotFoundException("No such ObjectID.");
            }
            targetClass = RUtil.classToRI(req.getClass());
        }
        catch (ClassNotFoundException e) {
            if (suffix != null && suffix.equals("Debug")) {
                throw new ClassNotFoundException("Could not determine class.");
            }
            Env.log.msg(2, "Class not found: \"" + className + "\" (" + e.getMessage() + ")");
            int[] sz = new int[]{(int)ConnectHandler.argSize(head, fid), (int)(ConnectHandler.argSize(head, fid) >> 32)};
            for (int i = 0; i < 2; ++i) {
                byte[] junk = new byte[sz[i]];
                in.read(junk);
            }
            rPointer rp = in.serialRead(rPointer.class);
            int tag = in.readInt();
            Header head2 = new Header(0L, tag, env.grp.myInfo());
            Except ex = new Except("Class not found.");
            Remote.answer(env.comm[member], head2, rp.objID(), ex, null);
            return;
        }
        Env.log.msg(5, "ObjectID: " + objID + " - Target class: " + targetClass.getName());
        Class[] args = new Class[]{OIStream.class, Header.class, Long.TYPE, FID.class, Integer.TYPE, Env.class};
        Object[] args2 = new Object[6];
        args2[0] = in;
        args2[1] = head;
        args2[2] = new Long(objID);
        args2[3] = fid;
        Env.log.msg(5, "" + member);
        Env.log.msg(5, "" + env.grp);
        args2[4] = new Integer(member);
        args2[5] = env;
        Method m = targetClass.getDeclaredMethod("accept", args);
        m.invoke(null, args2);
    }
}

