/*
 * Decompiled with CFR 0.152.
 */
package Test;

import CTL.Env;
import CTL.Streams.IStream;
import CTL.Streams.OIStream;
import CTL.Streams.OOStream;
import CTL.Types.CTLException;
import Impl.Types.DoubleDash;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;

public class TIStream
extends TestCase {
    private String[] tests = new String[4];

    public static String toString(Object data) {
        if (!data.getClass().isArray()) {
            return data.toString();
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < Array.getLength(data); ++i) {
            ret.append(Array.get(data, i) + " ");
        }
        return ret.toString();
    }

    public TIStream() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException, CTLException {
        PipedOutputStream pout = new PipedOutputStream();
        PipedInputStream pin = new PipedInputStream(pout);
        OOStream out = new OOStream(pout);
        OIStream in = new OIStream(pin);
        IStream intelli_stream = new IStream();
        Env.newLogger("test");
        int[] arr = new int[3];
        arr[2] = 3;
        arr[1] = 3;
        arr[0] = 3;
        double[] dbl = new double[2];
        dbl[1] = 2.0;
        dbl[0] = 2.0;
        long[] lng = new long[2];
        lng[1] = 3L;
        lng[0] = 3L;
        intelli_stream.write(Float.valueOf(0.1f));
        intelli_stream.write("foobar");
        intelli_stream.write(arr);
        intelli_stream.write(lng);
        intelli_stream.write(dbl);
        intelli_stream.write(1);
        intelli_stream.write(23L);
        intelli_stream.write(true);
        intelli_stream.write(new DoubleDash(0.1, 0.1f));
        intelli_stream.flush();
        this.tests[0] = intelli_stream.toString();
        intelli_stream.writeToIStream(out);
        out.flush();
        IStream stream2 = new IStream();
        stream2.readFromStream(in);
        stream2.flush();
        this.tests[1] = stream2.toString();
        intelli_stream.writeToStream(out, true);
        out.flush();
        StringBuffer buf = new StringBuffer();
        buf.append(in.readFloat() + "\n");
        buf.append(in.readString() + "\n");
        buf.append(TIStream.toString(in.readArray(Integer.TYPE, null)) + "\n");
        buf.append(TIStream.toString(in.readArray(Long.TYPE, null)) + "\n");
        buf.append(TIStream.toString(in.readArray(Double.TYPE, null)) + "\n");
        buf.append(in.readInt() + "\n");
        buf.append(in.readLong() + "\n");
        buf.append(in.readBoolean() + "\n");
        buf.append(in.serialRead(DoubleDash.class));
        this.tests[2] = buf.toString();
        this.tests[3] = intelli_stream.toString();
    }

    public void testCase1() {
        for (int i = 0; i < this.tests.length; ++i) {
            TIStream.assertTrue((boolean)this.tests[i].equals(this.tests[0]));
        }
    }

    public void testCase2() {
        for (int i = 0; i < this.tests.length; ++i) {
            TIStream.assertTrue((boolean)this.tests[i].equals(this.tests[1]));
        }
    }

    public void testCase3() {
        for (int i = 0; i < this.tests.length; ++i) {
            TIStream.assertTrue((boolean)this.tests[i].equals(this.tests[2]));
        }
    }

    public void testCase4() {
        for (int i = 0; i < this.tests.length; ++i) {
            TIStream.assertTrue((boolean)this.tests[i].equals(this.tests[3]));
        }
    }

    public static void main(String[] args) {
        try {
            TIStream mango = new TIStream();
            mango.testCase1();
            mango.testCase2();
            mango.testCase3();
            mango.testCase4();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

