/*
 * Decompiled with CFR 0.152.
 */
package ReflWrap;

import ReflWrap.ClassInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.StringTokenizer;

public class Refl {
    public static boolean hasAnot(String comp, Annotation[] anot) {
        for (int i = 0; i < anot.length; ++i) {
            if (!((Object)anot[i]).toString().equals(comp)) continue;
            return true;
        }
        return false;
    }

    public static String rtype(Class klass) {
        StringTokenizer str = new StringTokenizer(klass.toString(), ".");
        String ret = null;
        while (str.hasMoreTokens()) {
            ret = str.nextToken();
        }
        if (ret == null) {
            return null;
        }
        if ((ret = Refl.convert(ret)).equals("Boolean")) {
            return "boolean";
        }
        if (ret.equals("Byte")) {
            return "byte";
        }
        if (ret.equals("Char")) {
            return "char";
        }
        if (ret.equals("Double")) {
            return "double";
        }
        if (ret.equals("Float")) {
            return "float";
        }
        if (ret.equals("Int")) {
            return "int";
        }
        if (ret.equals("Long")) {
            return "long";
        }
        if (ret.equals("Short")) {
            return "short";
        }
        if (ret.charAt(ret.length() - 1) == ';') {
            ret = "Array";
        }
        return ret;
    }

    public static String type(String type) {
        if ((type = Refl.lastToken(type, " ")).toCharArray()[0] == '[') {
            return Refl.handleArray(type);
        }
        StringTokenizer tok = new StringTokenizer(type, ".");
        String retval = type;
        while (tok.hasMoreTokens()) {
            retval = tok.nextToken();
        }
        return retval;
    }

    public static String handleArray(String type) {
        if (type.equals("[Z")) {
            return "boolean[]";
        }
        if (type.equals("[B")) {
            return "byte[]";
        }
        if (type.equals("[I")) {
            return "int[]";
        }
        if (type.equals("[J")) {
            return "long[]";
        }
        if (type.equals("[S")) {
            return "short[]";
        }
        if (type.equals("[D")) {
            return "double[]";
        }
        if (type.equals("[F")) {
            return "float[]";
        }
        if (type.equals("[C")) {
            return "char[]";
        }
        if (type.length() > 2 && type.substring(0, 2).equals("[L")) {
            return type.substring(2, type.length() - 1) + "[]";
        }
        return type;
    }

    public static String arrayType(String type) {
        type = Refl.handleArray(type);
        StringTokenizer tok = new StringTokenizer(type, "[");
        return tok.nextToken();
    }

    public static String arrayType2(String type) {
        String moo = Refl.arrayType(type);
        if (moo.equals("boolean")) {
            return "Boolean.TYPE";
        }
        if (moo.equals("byte")) {
            return "Byte.TYPE";
        }
        if (moo.equals("char")) {
            return "Character.TYPE";
        }
        if (moo.equals("double")) {
            return "Double.TYPE";
        }
        if (moo.equals("float")) {
            return "Float.TYPE";
        }
        if (moo.equals("int")) {
            return "Integer.TYPE";
        }
        if (moo.equals("long")) {
            return "Long.TYPE";
        }
        if (moo.equals("short")) {
            return "Short.TYPE";
        }
        return moo + ".class";
    }

    public static Class getClass(String type) {
        if ((type = Refl.type(type)).equals("int") || type.equals("Int") || type.equals("Integer")) {
            return Integer.TYPE;
        }
        if (type.equals("long") || type.equals("Long")) {
            return Long.TYPE;
        }
        if (type.equals("short") || type.equals("Short")) {
            return Short.TYPE;
        }
        if (type.equals("float") || type.equals("Float")) {
            return Float.TYPE;
        }
        if (type.equals("double") || type.equals("Double")) {
            return Double.TYPE;
        }
        if (type.equals("boolean") || type.equals("Boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("byte") || type.equals("Byte")) {
            return Byte.TYPE;
        }
        if (type.equals("char") || type.equals("Char") || type.equals("Character")) {
            return Character.TYPE;
        }
        if (type.equals("String")) {
            return String.class;
        }
        if (type.equals("Object") || type.equals("Array")) {
            return Object.class;
        }
        return null;
    }

    public static String class_(Class moo) {
        ClassInfo cinfo = new ClassInfo(moo);
        return cinfo.clstr();
    }

    public static String defaultVal(String type) {
        if ((type = Refl.type(type)).equals("int")) {
            return "Integer.MIN_VALUE";
        }
        if (type.equals("double")) {
            return "Double.NaN";
        }
        if (type.equals("float")) {
            return "Float.NaN";
        }
        if (type.equals("long")) {
            return "Long.MIN_VALUE";
        }
        if (type.equals("short")) {
            return "Short.MIN_VALUE";
        }
        if (type.equals("boolean")) {
            return "false";
        }
        if (type.equals("byte")) {
            return "Byte.MIN_VALUE";
        }
        if (type.equals("char")) {
            return "(char)-1";
        }
        return "null";
    }

    public static Object defaultVal2(String type) {
        if ((type = Refl.type(type)).equals("int")) {
            return new Integer(Integer.MIN_VALUE);
        }
        if (type.equals("double")) {
            return new Double(Double.NaN);
        }
        if (type.equals("float")) {
            return new Float(Float.NaN);
        }
        if (type.equals("long")) {
            return new Long(Long.MIN_VALUE);
        }
        if (type.equals("short")) {
            return new Short(Short.MIN_VALUE);
        }
        if (type.equals("boolean")) {
            return new Boolean(false);
        }
        if (type.equals("byte")) {
            return new Byte(-128);
        }
        if (type.equals("char")) {
            return new Character('\uffff');
        }
        return null;
    }

    public static String convert(String type) {
        if ((type = Refl.type(type)).equals("Integer")) {
            type = "Int";
        }
        if (type.equals("Character")) {
            type = "Char";
        }
        if (type.length() > 2 && type.substring(type.length() - 2, type.length()).equals("[]")) {
            return "Array";
        }
        char[] foo = type.toCharArray();
        if (foo[0] - 32 > 64) {
            foo[0] = (char)(foo[0] - 32);
        }
        return new String(foo);
    }

    public static String firstToken(String str, String tok) {
        StringTokenizer t = new StringTokenizer(str, tok);
        return t.nextToken();
    }

    public static String lastToken(String str, String tok) {
        String ret = null;
        StringTokenizer t = new StringTokenizer(str, tok);
        while (t.hasMoreTokens()) {
            ret = t.nextToken();
        }
        return ret;
    }

    public static boolean hasToken(String str, String tok) {
        StringTokenizer t = new StringTokenizer(str, tok);
        return t.countTokens() >= 2;
    }

    public static String printType(Type t) {
        String ret = Refl.handleArray(Refl.lastToken(t.toString(), " "));
        if (Refl.hasToken(ret, "<")) {
            StringBuffer buf = new StringBuffer();
            buf.append(Refl.lastToken(Refl.firstToken(ret, "<"), ".") + "<");
            String tmp = Refl.lastToken(ret, "<");
            buf.append(Refl.lastToken(tmp.substring(0, tmp.length() - 1), ".") + ">");
            ret = buf.toString();
        } else {
            ret = Refl.lastToken(ret, ".");
        }
        return ret;
    }

    public static boolean[] booleanArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        boolean[] ret = new boolean[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (Boolean)tmp[i];
        }
        return ret;
    }

    public static byte[] byteArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (Byte)tmp[i];
        }
        return ret;
    }

    public static char[] charArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        char[] ret = new char[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = ((Character)tmp[i]).charValue();
        }
        return ret;
    }

    public static double[] doubleArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (Double)tmp[i];
        }
        return ret;
    }

    public static float[] floatArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        float[] ret = new float[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = ((Float)tmp[i]).floatValue();
        }
        return ret;
    }

    public static int[] intArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (Integer)tmp[i];
        }
        return ret;
    }

    public static long[] longArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        long[] ret = new long[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (Long)tmp[i];
        }
        return ret;
    }

    public static short[] shortArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        short[] ret = new short[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (Short)tmp[i];
        }
        return ret;
    }

    public static String[] StringArray(Object data) {
        Object[] tmp = (Object[])data;
        int len = tmp.length;
        String[] ret = new String[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (String)tmp[i];
        }
        return ret;
    }

    public static Object[] ObjectArray(Object data) {
        return (Object[])data;
    }
}

