/*
 * Decompiled with CFR 0.152.
 */
package ReflWrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;

public class ConstructInfo {
    private Constructor c;
    private String name;
    private String[] params;

    public Constructor c() {
        return this.c;
    }

    public String name() {
        return this.name;
    }

    public String[] params() {
        return this.params;
    }

    public ConstructInfo(Constructor construct) {
        this.c = construct;
        this.name = this.c.getName();
        Class<?>[] p = this.c.getParameterTypes();
        this.params = new String[p.length];
        for (int i = 0; i < p.length; ++i) {
            StringTokenizer str = new StringTokenizer(p[i].getName(), ".");
            this.params[i] = null;
            while (str.hasMoreTokens()) {
                this.params[i] = str.nextToken();
            }
            int len = this.params[i].length();
            if (!this.params[i].substring(len - 1, len).equals(";")) continue;
            this.params[i] = this.params[i].substring(0, len - 1) + "[]";
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.modifiersToString());
        ret.append(this.name + " (");
        ret.append(this.paramsToString());
        return ret.toString();
    }

    public String paramsToString() {
        int i;
        StringBuffer ret = new StringBuffer();
        for (i = 0; i < this.params.length; ++i) {
            ret.append(this.params[i] + " arg" + i + (i == this.params.length - 1 ? ")" : ", "));
        }
        if (i == 0) {
            ret.append(")");
        }
        return ret.toString();
    }

    public String modifiersToString() {
        StringBuffer sb = new StringBuffer();
        int mod = this.c.getModifiers();
        if ((mod & 1) != 0) {
            sb.append("public ");
        }
        if ((mod & 2) != 0) {
            sb.append("private ");
        }
        if ((mod & 4) != 0) {
            sb.append("protected ");
        }
        if ((mod & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 8) != 0) {
            sb.append("static ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("final ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((mod & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((mod & 0x100) != 0) {
            sb.append("native ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((mod & 0x200) != 0) {
            sb.append("interface ");
        }
        return sb.toString();
    }

    public Annotation[] getParamAnot(int i) {
        Annotation[][] aa = this.c.getParameterAnnotations();
        return aa[i];
    }
}

