/*
 * Decompiled with CFR 0.152.
 */
package ReflWrap;

import ReflWrap.Refl;
import ReflWrap.TypeTree;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCode {
    public static String sed(String input, String pat, String repl) {
        Pattern p = Pattern.compile(pat);
        Matcher m = p.matcher(input);
        return m.replaceAll(repl);
    }

    private static LinkedList<String> params(String types) {
        LinkedList<String> ret = new LinkedList<String>();
        Pattern p = Pattern.compile(">;");
        String[] blah = p.split(types);
        for (int i = 0; i < blah.length; ++i) {
            ret.add(ByteCode.sed(blah[i] + ">", ";", ","));
        }
        return ret;
    }

    private static String retval(String returns) {
        String ret = returns.substring(returns.indexOf(")") + 1, returns.length());
        ret = ByteCode.sed(ret, ";\\)", "");
        return ret;
    }

    public static boolean matches(String str, String regexp) {
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static String unclassify(String str) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(str, " ");
        while (tok.hasMoreTokens()) {
            buf.append(Refl.lastToken(tok.nextToken(), ".") + " ");
        }
        return buf.toString();
    }

    public static LinkedList<String> getMethods(String klass) {
        LinkedList<String> ret = new LinkedList<String>();
        JavaClass c = Repository.lookupClass((String)klass);
        if (c == null) {
            return ret;
        }
        for (Method m : c.getMethods()) {
            String mt = Refl.firstToken(m.toString(), "[");
            mt = ByteCode.sed(mt, "\\(", " ( ");
            mt = ByteCode.sed(mt, "\\)", " )");
            mt = ByteCode.sed(mt, " arg[0-9]*", "");
            mt = ByteCode.unclassify(mt);
            mt = ByteCode.sed(mt, "\\( ", "(");
            if (ByteCode.matches(mt = ByteCode.sed(mt, " \\) $", ")"), ".*<init>.*")) continue;
            ret.add(mt);
        }
        return ret;
    }

    public static LinkedList<TypeTree> getParameters(String klass, int fid) {
        JavaClass c = Repository.lookupClass((String)klass);
        if (c == null) {
            return new LinkedList<TypeTree>();
        }
        Method[] m = c.getMethods();
        if (++fid > m.length - 1) {
            return new LinkedList<TypeTree>();
        }
        return ByteCode.handleMethod(m[fid]);
    }

    public static TypeTree getRetVal(String klass, int fid) {
        JavaClass c = Repository.lookupClass((String)klass);
        if (c == null) {
            return null;
        }
        Method[] m = c.getMethods();
        if (++fid > m.length - 1) {
            return null;
        }
        String sign = ByteCode.retval(ByteCode.getSign(m[fid]));
        try {
            return new TypeTree(sign);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String getSign(Method m) {
        String sign = "[Signature(";
        String str = m.toString();
        int idx = str.indexOf(sign);
        sign = str.substring(idx + sign.length(), str.length() - 1);
        sign = ByteCode.sed(sign, "<L", "<");
        sign = ByteCode.sed(sign, ";>", ">");
        sign = ByteCode.sed(sign, ";L", ";");
        sign = ByteCode.sed(sign, "\\)L", ")");
        sign = ByteCode.sed(sign, "/", ".");
        sign = ByteCode.sed(sign, "\\(L", "");
        return sign;
    }

    private static LinkedList<TypeTree> handleMethod(Method m) {
        String sign;
        int end = (sign = ByteCode.getSign(m)).indexOf(")");
        LinkedList<String> list = ByteCode.params(sign.substring(0, end == -1 ? sign.length() : end));
        LinkedList<TypeTree> ret = new LinkedList<TypeTree>();
        for (String s : list) {
            try {
                ret.add(new TypeTree(s));
            }
            catch (ClassNotFoundException e) {}
        }
        return ret;
    }
}

