/*
 * Decompiled with CFR 0.152.
 */
package NCLib;

import NCLib.Files;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private String input;
    private HashMap<String, String> map = new HashMap();

    public Template(String fname) {
        this.input = Files.readAll(fname);
        Pattern p = Pattern.compile("%.*\\%");
        Matcher m = p.matcher(this.input);
        while (m.find()) {
            String tmp = m.group();
            tmp = tmp.substring(1, tmp.length() - 1);
            this.map.put(tmp, "");
        }
    }

    public Set<String> fields() {
        return this.map.keySet();
    }

    public boolean set(String key, String value) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        this.map.put(key, value);
        return true;
    }

    public String toString() {
        String ret = this.input;
        for (String key : this.fields()) {
            String value = this.map.get(key);
            Pattern p = Pattern.compile("%" + key + "%");
            Matcher m = p.matcher(ret);
            ret = m.replaceAll(value);
        }
        return ret;
    }

    public void write(String fname) {
        Files.writeAll(fname, this.toString());
    }

    public static void main(String[] args) {
        Template tmpl = new Template("data/test.tmpl");
        tmpl.set("name", "Frankie");
        tmpl.set("name2", "Ocle");
        System.out.print(tmpl);
    }
}

