/*
 * Decompiled with CFR 0.152.
 */
package Hitman.HTTP;

import Hitman.HTTP.Header;
import Hitman.HTTP.Request;
import Hitman.IOUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class Server {
    private static String www_root = "www";

    private static void error(BufferedWriter out, short errcode) throws IOException {
        Header header = null;
        String repl = null;
        switch (errcode) {
            case 404: {
                StringBuffer buf = new StringBuffer();
                buf.append("<html><head><title>Mogguh!</title></head>");
                buf.append("<body>Document not found.</body></html>");
                repl = buf.toString();
                header = new Header(errcode, "text/html", repl);
                break;
            }
            default: {
                header = new Header(500);
            }
        }
        header.writeTo(out);
        if (repl != null) {
            out.write(repl, 0, repl.length());
        }
        out.flush();
    }

    private static void reply(BufferedWriter out, String cntType, String cnt) throws IOException {
        Header head = new Header(cntType, cnt);
        head.writeTo(out);
        out.write(cnt, 0, cnt.length());
        out.flush();
    }

    private static void reply(BufferedWriter out, File file) throws IOException {
        long len = file.length();
        if (len > Integer.MAX_VALUE) {
            System.err.println("Hitman does not support large files.");
        }
        if (IOUtil.getExt(file).equals("cgi")) {
            Server.handle_cgi(out, file);
            return;
        }
        byte[] buf = new byte[(int)len];
        FileInputStream in = new FileInputStream(file);
        in.read(buf);
        in.close();
        Server.reply(out, IOUtil.getFileType(file), new String(buf));
    }

    private static void handle_cgi(BufferedWriter out, File cgi) throws IOException {
        String cmd = "/usr/bin/env -i HOME=/dev/null PATH=/bin:/usr/bin " + cgi.getAbsolutePath();
        String res = IOUtil.exec(cmd);
        StringTokenizer tok = new StringTokenizer(res, "\n\n");
        String typ = tok.nextToken();
        StringTokenizer tok2 = new StringTokenizer(typ, ":");
        String moo = tok2.nextToken();
        String type = typ.substring(moo.length() + 2, typ.length());
        StringBuffer cnt = new StringBuffer();
        while (tok.hasMoreTokens()) {
            cnt.append(tok.nextToken() + "\n");
        }
        Server.reply(out, type, cnt.toString());
    }

    public static void main(String[] args) {
        try {
            ServerSocket ssock = new ServerSocket(0, 1);
            System.out.println("Listening on " + ssock.getLocalPort());
            ListenThread thr = new ListenThread(ssock);
            thr.start();
            IOUtil.exec("java -cp src Hitman.HTTP.Client http://localhost:" + ssock.getLocalPort() + "/");
            thr.join();
            ssock.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ListenThread
    extends Thread {
        private ServerSocket ssock = null;

        public ListenThread(ServerSocket ssock) {
            this.ssock = ssock;
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            try {
                Socket sock = this.ssock.accept();
                Request req = new Request(sock);
                BufferedWriter write = (BufferedWriter)req.recv();
                if (req.head.repl.equals("/")) {
                    Server.reply(write, "text/plain", "java httpd");
                } else {
                    File file = new File(www_root, req.head.repl);
                    if (!file.exists()) {
                        Server.error(write, (short)404);
                    } else {
                        Server.reply(write, file);
                    }
                }
                sock.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

