/*
 * Decompiled with CFR 0.152.
 */
package CTL.Streams;

import CTL.Streams.LittleEndian;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class DataInputStream2
implements DataInput {
    private DataInputStream stream;
    private boolean swapBytes = false;

    public DataInputStream2(InputStream stream) {
        this.stream = new DataInputStream(stream);
    }

    public void changeEndianess(ByteOrder order) {
        this.swapBytes = order == ByteOrder.LITTLE_ENDIAN;
    }

    public boolean readBoolean() throws IOException {
        return this.stream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.stream.readByte();
    }

    public char readChar() throws IOException {
        char read = this.stream.readChar();
        if (this.swapBytes) {
            read = Character.reverseBytes(read);
        }
        return read;
    }

    public double readDouble() throws IOException {
        double read = this.stream.readDouble();
        if (this.swapBytes) {
            read = LittleEndian.doubleReverseBytes(read);
        }
        return read;
    }

    public float readFloat() throws IOException {
        float read = this.stream.readFloat();
        if (this.swapBytes) {
            read = LittleEndian.floatReverseBytes(read);
        }
        return read;
    }

    public void readFully(byte[] b) throws IOException {
        this.stream.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
    }

    public int readInt() throws IOException {
        int read = this.stream.readInt();
        if (this.swapBytes) {
            read = Integer.reverseBytes(read);
        }
        return read;
    }

    public String readLine() throws IOException {
        return this.stream.readLine();
    }

    public long readLong() throws IOException {
        long read = this.stream.readLong();
        if (this.swapBytes) {
            read = Long.reverseBytes(read);
        }
        return read;
    }

    public short readShort() throws IOException {
        short read = this.stream.readShort();
        if (this.swapBytes) {
            read = Short.reverseBytes(read);
        }
        return read;
    }

    public int readUnsignedByte() throws IOException {
        int read = this.stream.readUnsignedByte();
        if (this.swapBytes) {
            read = Integer.reverseBytes(read);
        }
        return read;
    }

    public int readUnsignedShort() throws IOException {
        int read = this.stream.readUnsignedShort();
        if (this.swapBytes) {
            read = Integer.reverseBytes(read);
        }
        return read;
    }

    public String readUTF() throws IOException {
        return this.stream.readUTF();
    }

    public int skipBytes(int n) throws IOException {
        return this.stream.skipBytes(n);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }
}

