/*
 * Decompiled with CFR 0.152.
 */
package CTL.Serialize;

import CTL.Env;
import CTL.Java;
import CTL.Streams.DataOutputStream2;
import CTL.Types.CTLException;
import ReflWrap.ClassInfo;
import ReflWrap.TypeTree;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerialOut
extends DataOutputStream2 {
    public SerialOut(OutputStream out) throws IOException {
        super(out);
    }

    public abstract void writeString(String var1) throws IOException;

    public abstract void writeWString(String var1) throws IOException;

    public abstract <T> void writeArray(T var1) throws IOException, IllegalAccessException, InvocationTargetException;

    public abstract <T> void __writeArray(T var1) throws IOException, IllegalAccessException, InvocationTargetException;

    public abstract void writeObject(Object var1) throws IOException, IllegalAccessException, InvocationTargetException, CTLException;

    protected abstract void writeData(Object var1) throws IOException, IllegalAccessException, InvocationTargetException, CTLException;

    public void serialWrite(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        if (data == null) {
            throw new CTLException("No data to write");
        }
        Env.log.msg(5, "serialWrite(): " + data.getClass().getName());
        if (data instanceof String) {
            this.writeString((String)data);
            return;
        }
        if (data.getClass().isArray()) {
            this.writeArray(data);
            return;
        }
        if (data instanceof Boolean) {
            this.writeBoolean((Boolean)data);
            return;
        }
        if (data instanceof Byte) {
            this.writeByte((Byte)data);
            return;
        }
        if (data instanceof Character) {
            this.writeChar(((Character)data).charValue());
            return;
        }
        if (data instanceof Double) {
            this.writeDouble((Double)data);
            return;
        }
        if (data instanceof Float) {
            this.writeFloat(((Float)data).floatValue());
            return;
        }
        if (data instanceof Integer) {
            this.writeInt((Integer)data);
            return;
        }
        if (data instanceof Long) {
            this.writeLong((Long)data);
            return;
        }
        if (data instanceof Short) {
            this.writeShort((Short)data);
            return;
        }
        if (data instanceof LinkedList) {
            Java.writeLinkedList(this, (LinkedList)data);
            return;
        }
        if (data instanceof HashMap) {
            Java.writeHashMap(this, (HashMap)data);
            return;
        }
        if (data instanceof HashSet) {
            Java.writeHashSet(this, (HashSet)data);
            return;
        }
        if (data instanceof Stack) {
            Java.writeStack(this, (Stack)data);
            return;
        }
        if (data instanceof Vector) {
            Java.writeVector(this, (Vector)data);
            return;
        }
        if (data instanceof TypeTree) {
            Java.writeTypeTree(this, (TypeTree)data);
            return;
        }
        ClassInfo cinfo = new ClassInfo(data.getClass());
        if (!cinfo.implementing("CTL.Serialize.Writable")) {
            Env.log.msg(2, "OOStream: Class " + cinfo.fqcn() + " does not implement the Writable-Interface.");
            return;
        }
        this.writeData(data);
    }
}

