/*
 * Decompiled with CFR 0.152.
 */
package CTL.Serialize;

import CTL.RUtil;
import CTL.Serialize.CTLOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import ReflWrap.Refl;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASCIIOut
extends CTLOut {
    private CTLOut file;

    public ASCIIOut(OutputStream out, OutputStream file) throws IOException {
        super(out);
        this.file = new CTLOut(file);
    }

    private void dump(String s) throws IOException {
        this.file.writeBytes(s + "\n");
    }

    @Override
    public void writeBoolean(boolean data) throws IOException {
        super.writeBoolean(data);
        this.dump("Boolean: " + data);
    }

    @Override
    public void writeByte(byte data) throws IOException {
        super.writeByte(data);
        this.dump("Byte: " + data);
    }

    @Override
    public void writeChar(char data) throws IOException {
        super.writeChar(data);
        this.dump("Char: " + data);
    }

    @Override
    public void writeDouble(double data) throws IOException {
        super.writeDouble(data);
        this.dump("Double: " + data);
    }

    @Override
    public void writeFloat(float data) throws IOException {
        super.writeFloat(data);
        this.dump("Float: " + data);
    }

    @Override
    public void writeInt(int data) throws IOException {
        super.writeInt(data);
        this.dump("Int: " + data);
    }

    @Override
    public void writeLong(long data) throws IOException {
        super.writeLong(data);
        this.dump("Long: " + data);
    }

    @Override
    public void writeShort(short data) throws IOException {
        super.writeShort(data);
        this.dump("Short: " + data);
    }

    @Override
    public void writeString(String data) throws IOException {
        super.writeString(data);
        this.dump("String: " + data);
    }

    @Override
    public void writeWString(String data) throws IOException {
        super.writeWString(data);
        this.dump("WString: " + data);
    }

    @Override
    protected void writeData(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        super.writeData(data);
        ((Writable)data).write(this.file);
    }

    @Override
    public <T> void writeArray(T data) throws IOException, IllegalAccessException, InvocationTargetException {
        super.writeArray(data);
        if (data == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(Array.getLength(data));
        this.__writeArray(data);
    }

    @Override
    public <T> void __writeArray(T data) throws IOException, IllegalAccessException, InvocationTargetException {
        super.__writeArray(data);
        if (data == null) {
            return;
        }
        String type = null;
        try {
            type = Array.get(data, 0).getClass().getName();
        }
        catch (NullPointerException e) {
            type = Refl.arrayType(data.getClass().getName());
        }
        Method m = RUtil.getWriter(type);
        Object[] args = new Object[1];
        for (int i = 0; i < Array.getLength(data); ++i) {
            args[0] = Array.get(data, i);
            m.invoke((Object)this, args);
        }
    }

    @Override
    public void writeObject(Object data) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        super.writeObject(data);
        this.file.writeObject(data);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.file.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.file.close();
    }
}

