/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Env;
import CTL.ObjectMapEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.ListIterator;

public class ObjectMap {
    private int counter = 0;
    private LinkedList<ObjectMapEntry> list = new LinkedList();

    public int getCounter() {
        return this.counter;
    }

    public int createObj(Constructor c, Object[] args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object obj = c.newInstance(args);
        int hash = obj.hashCode();
        ObjectMapEntry entry = new ObjectMapEntry(hash, obj);
        this.list.add(entry);
        ++this.counter;
        Env.log.msg(5, "Created Object " + hash + ".");
        Env.log.msg(7, "Created " + this.counter + " object(s).");
        return hash;
    }

    public int regObj(Object obj) {
        return this.regObj(obj, obj.hashCode());
    }

    public int regObj(Object obj, int ID) {
        ObjectMapEntry entry = new ObjectMapEntry(ID, obj);
        this.list.add(entry);
        ++this.counter;
        return ID;
    }

    public Object getObj(int hash) {
        ListIterator iter = this.list.listIterator();
        while (iter.hasNext()) {
            ObjectMapEntry entry = (ObjectMapEntry)iter.next();
            if (entry.getHash() != hash) continue;
            return entry.getObj();
        }
        return null;
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        buf.append("ObjectMap dump:\n");
        for (ObjectMapEntry e : this.list) {
            buf.append("\t\t" + e.toString() + "\n");
        }
        buf.append("\t\tEOD");
        return buf.toString();
    }
}

