/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Globals;
import ReflWrap.ByteCode;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;

public class Logger {
    public static final int ERR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DBG = 5;
    public static final int DBG1 = 6;
    public static final int DBG2 = 7;
    public static final int ALL = Integer.MAX_VALUE;
    private FileWriter file;
    private static int loglevel = 3;

    private Logger(String fname) {
        try {
            String stamp = "";
            if (Globals.LogTimeStamp) {
                stamp = "-" + Logger.gettimeofday(true);
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                StringTokenizer tok = new StringTokenizer(System.getenv("TMP"), "\\");
                StringBuffer tmp = new StringBuffer();
                while (tok.hasMoreTokens()) {
                    tmp.append(tok.nextToken() + "/");
                }
                fname = ByteCode.sed(fname, "/tmp/", tmp.toString());
            }
            fname = fname + stamp + ".log";
            this.file = new FileWriter(fname);
        }
        catch (IOException e) {
            System.err.println(fname + ": Logging error.");
        }
    }

    public Logger(String fname, int loglevel) {
        this(fname);
        Logger.loglevel = loglevel;
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            System.err.println("Logging error.");
        }
    }

    public void msg(int lvl, String msg) {
        try {
            if (Globals.LogScope) {
                Throwable ex = new Throwable();
                for (int i = 0; i < Globals.LogScopeDepth; ++i) {
                    StackTraceElement head = ex.getStackTrace()[i + 1];
                    msg = head.getClassName() + "." + head.getMethodName() + " :: " + msg;
                }
            }
            if (lvl <= loglevel) {
                this.file.write(Logger.gettimeofday(false) + "  " + msg + System.getProperty("line.separator"));
                this.file.flush();
            }
        }
        catch (IOException e) {
            System.err.println("Logging error.");
        }
    }

    public void msg(String msg) {
        this.msg(4, msg);
    }

    private static String gettimeofday(boolean foo) {
        SimpleTimeZone pdt = new SimpleTimeZone(3600000, "Europe/Berlin");
        GregorianCalendar cal = new GregorianCalendar(pdt);
        Date date = new Date();
        cal.setTime(date);
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        if (foo) {
            fmt.format("%d%d%d", cal.get(11), cal.get(12), cal.get(13));
        } else {
            fmt.format("%2d:%2d:%2d", cal.get(11), cal.get(12), cal.get(13));
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println(Logger.gettimeofday(true));
    }
}

