/*
 * Decompiled with CFR 0.152.
 */
package CTL.Comm;

import CTL.Comm.BuffyOut;
import CTL.Comm.Communicator;
import CTL.Env;
import CTL.RUtil;
import CTL.Remote;
import CTL.Types.Header;
import CTL.Types.Location;
import CTL.Types.PeerID;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.OutputStream;

public class SSHv2
implements Runnable {
    private String start;
    private Location loc;
    private Communicator comm;

    public static boolean hasPrivateKey() {
        return new File(System.getProperty("user.home") + "/.ssh/id_rsa").exists();
    }

    public SSHv2(Location loc, Communicator comm, Env env) {
        this.comm = comm;
        this.loc = loc;
        this.start = "";
        this.start = this.start + loc.path() + "/" + loc.cmd() + " -l tcp -h " + comm.pid().host() + " -S " + env.grp.members() + " -f /tmp/service.log" + " -v -L " + comm.pid().port() + " -p " + (env.grp.myID() + 1);
        Env.log.msg(7, "Starting service with " + this.start);
        if (Env.debugger != null) {
            this.start = this.start + " -D " + Env.debugger.host() + ":" + Env.debugger.port();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String hosts;
            if (this.loc == null || this.loc.path() == null || this.loc.cmd() == null) {
                Env.log.msg(2, "Location not initialized!");
                throw new RuntimeException("No location to connect to.");
            }
            if (Env.debugger != null) {
                BuffyOut out = new BuffyOut();
                PeerID pid = new PeerID(this.loc.host(), this.loc.port());
                Header head = new Header(pid.size(), 20, this.comm.pid(), -1);
                out.o.serialWrite(head);
                out.o.serialWrite(pid);
                out.o.flush();
                Remote.writeDBG(this.comm, out.getBytes());
            }
            JSch jsch = new JSch();
            if (SSHv2.hasPrivateKey()) {
                jsch.addIdentity(System.getProperty("user.home") + "/.ssh/id_rsa");
            }
            if (new File(hosts = System.getProperty("user.home") + "/.ssh/known_hosts").exists()) {
                jsch.setKnownHosts(hosts);
            } else {
                Env.log.msg(2, hosts + ": No such file or directory.");
            }
            Env.log.msg(4, this.loc.toString());
            if (this.loc.user == null) {
                this.loc.user = System.getProperty("user.name");
            }
            Session sess = jsch.getSession(this.loc.user, this.loc.host(), this.loc.port());
            this.loc.setPassword(sess);
            sess.connect();
            Channel chan = sess.openChannel("exec");
            if (chan == null) {
                Env.log.msg(2, "Session could not be opened.");
                throw new RuntimeException("SSH connection refused.");
            }
            ((ChannelExec)chan).setCommand(this.start);
            chan.connect();
            if (chan.isEOF()) {
                throw new RuntimeException("SSH connection reset.");
            }
            chan.setOutputStream((OutputStream)System.out);
            ((ChannelExec)chan).setErrStream((OutputStream)System.err);
            Env.log.msg(4, "Service spawned via SSH.");
            while (!chan.isEOF()) {
                Thread.sleep(500L);
            }
            sess.disconnect();
        }
        catch (Exception e) {
            Env.log.msg(2, RUtil.stackTrace(e));
        }
        finally {
            if (Env.clean) {
                return;
            }
            System.out.println("Unexpected termination of remote service.");
            this.comm.notifyErr();
        }
    }
}

