/*
 * Decompiled with CFR 0.152.
 */
package Hitman.HTTP;

import Hitman.HTTP.Header;
import Hitman.HURL;
import Hitman.IOUtil;
import Hitman.NetRequest;
import Hitman.NetStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;

public class Request
extends NetRequest {
    protected static final String uagent = "Hitman.HTTP v0.1";
    public Header head = null;
    private byte[] payload = null;
    private byte[] reply = null;
    private Type type = Type.UNDEF;

    public Request(HURL url) {
        this(url, Type.GET);
    }

    public Request(HURL url, Type type) {
        this(url, type, (byte[])null, null);
    }

    public Request(HURL url, Type type, String payload, String cntType) {
        this(url, type, payload.getBytes(), cntType);
    }

    public Request(HURL url, Type type, byte[] payload, String cntType) {
        super(url);
        this.type = type;
        this.payload = payload;
        this.head = new Header(Request.TypeToString(type), url.path(), payload == null ? -1 : payload.length);
        if (payload != null) {
            this.head.addHeader("Content-Type", cntType);
        }
    }

    public Request(Socket sock) {
        super(sock);
    }

    public byte[] getReply() {
        return this.reply;
    }

    private void get_request(BufferedReader in) throws IOException {
        this.head = new Header(in);
        if (this.head.len > 0L) {
            this.payload = IOUtil.slurp((Reader)in, this.head.len).getBytes();
        }
    }

    public Writer recv() throws IOException {
        if (this.sock == null) {
            return null;
        }
        this.get_request(Request.getReader(this.sock));
        return Request.getWriter(this.sock);
    }

    public Reader send(boolean slurp) throws IOException {
        if (this.url == null) {
            return null;
        }
        Socket sock = new Socket(this.url.host(), this.url.port());
        BufferedReader in = Request.getReader(sock);
        BufferedWriter out = Request.getWriter(sock);
        this.head.writeTo(out);
        if (this.payload != null) {
            out.write(this.payload.toString(), 0, this.payload.toString().length());
        }
        out.flush();
        Header head = new Header(in);
        if (!slurp) {
            return in;
        }
        if (head.len > 0L) {
            this.reply = IOUtil.slurp((Reader)in, head.len).getBytes();
            if ((long)this.reply.length != head.len) {
                System.err.println("Range not satisfied.");
            }
        } else {
            this.reply = IOUtil.slurp(in).getBytes();
        }
        sock.close();
        return null;
    }

    public NetStatus status() {
        return null;
    }

    private static String TypeToString(Type type) {
        switch (type) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "POST";
            }
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNDEF,
        GET,
        POST;

    }
}

