/*
 * Decompiled with CFR 0.152.
 */
package Hitman.HTTP;

import Hitman.Dating;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Header {
    private static String[] udef = new String[6];
    protected String proto = "HTTP/1.0";
    protected short retcode = (short)-1;
    protected String req = null;
    protected String repl = null;
    protected long len = -1L;
    protected Date date = null;
    protected Date last_mod = null;
    protected HashMap<String, String> usrdef = null;

    public Header(String req, String path, long len) {
        this.req = req;
        this.repl = path;
        this.len = len;
        this.usrdef = new HashMap();
        this.usrdef.put(udef[5], "Hitman.HTTP v0.1");
    }

    public Header(short code) {
        this.retcode = code;
        this.repl = this.getReply(this.retcode);
        this.date = new Date();
        this.usrdef = new HashMap();
        this.usrdef.put(udef[0], "Hitman server v0.1");
        this.usrdef.put(udef[3], "close");
    }

    public Header(short code, String type, String cnt) {
        this(code);
        this.len = cnt.length();
        this.last_mod = new Date();
        this.usrdef.put(udef[4], type);
    }

    public Header(String type, String cnt) {
        this(200, type, cnt);
    }

    public Header(BufferedReader buf) {
        boolean read = true;
        this.usrdef = new HashMap();
        try {
            String msg = buf.readLine();
            StringTokenizer str = new StringTokenizer(msg, " ");
            if (str.countTokens() < 3) {
                System.err.println("Weird HTTP reply.");
                this.retcode = (short)417;
                this.repl = "Expectation Failed";
            } else {
                this.proto = str.nextToken();
                if (this.proto.equals("GET") || this.proto.equals("POST")) {
                    String moo = this.proto;
                    this.repl = str.nextToken();
                    this.proto = str.nextToken();
                    this.req = moo;
                } else {
                    this.retcode = Short.parseShort(str.nextToken());
                    StringBuffer b = new StringBuffer();
                    while (str.hasMoreTokens()) {
                        b.append(str.nextToken() + " ");
                    }
                    this.repl = b.toString();
                }
            }
            if (this.retcode >= 400) {
                System.out.println("Error occured: " + this.retcode + " " + this.repl);
                return;
            }
            while (read) {
                String line = buf.readLine();
                if (line.equals("")) {
                    read = false;
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(line, ":");
                if (tok.countTokens() < 2) continue;
                String key = tok.nextToken();
                String value = line.substring(key.length() + 2, line.length());
                for (int i = 0; i < udef.length; ++i) {
                    if (!key.equalsIgnoreCase(udef[i])) continue;
                    this.usrdef.put(udef[i], value);
                }
                if (key.equalsIgnoreCase("Content-length")) {
                    this.len = Long.parseLong(value);
                }
                if (key.equalsIgnoreCase("Date")) {
                    this.date = Dating.parse(value);
                }
                if (key.equalsIgnoreCase("Last-Modified")) {
                    this.last_mod = Dating.parse(value);
                }
                if (!key.equalsIgnoreCase("Transfer-Encoding") || !value.equalsIgnoreCase("chunked")) continue;
                this.len = -2L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String get(String key) {
        return this.usrdef.get(key);
    }

    private String userdef() {
        StringBuffer buf = new StringBuffer();
        Set<Map.Entry<String, String>> set = this.usrdef.entrySet();
        for (Map.Entry<String, String> m : set) {
            buf.append(m.getKey() + ": " + m.getValue() + "\n");
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.req != null) {
            buf.append(this.req + " " + this.repl + " " + this.proto + "\n");
        }
        buf.append(this.userdef());
        return buf.toString();
    }

    public void writeTo(BufferedWriter out) throws IOException {
        StringBuffer buf = new StringBuffer();
        if (this.req == null) {
            buf.append(this.proto + " " + this.retcode + " " + this.repl + "\r\n");
            buf.append("Date: " + this.date + "\n");
            if (this.last_mod != null) {
                buf.append("Last-Modified: " + this.last_mod + "\n");
            }
        } else {
            buf.append(this.req + " " + this.repl + " " + this.proto + "\r\n");
        }
        if (this.len != -1L) {
            buf.append("Content-Length: " + this.len + "\n");
        }
        buf.append(this.userdef() + "\n\n");
        out.write(buf.toString(), 0, buf.toString().length());
    }

    public String getReply(short code) {
        switch (code) {
            case 200: {
                return "OK";
            }
            case 404: {
                return "Not Found";
            }
            case 500: {
                return "Internal Server Error";
            }
        }
        return null;
    }

    public void addHeader(String key, String value) {
        this.usrdef.put(key, value);
    }

    static {
        Header.udef[0] = "Server";
        Header.udef[1] = "ETag";
        Header.udef[2] = "Accept-Ranges";
        Header.udef[3] = "Connection";
        Header.udef[4] = "Content-Type";
        Header.udef[5] = "User-Agent";
    }
}

