/*
 * Decompiled with CFR 0.152.
 */
package Debug;

import CTL.Comm.TCPCommunicator;
import CTL.Env;
import CTL.Streams.OIStream;
import CTL.Streams.OOStream;
import CTL.Types.Header;
import CTL.Types.Location;
import CTL.Types.PeerID;
import NCLib.Process;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;

public class DummyDebugger {
    private static final boolean manual = false;
    private static int recv = 0;

    public static void main(String[] a) {
        LinkedList<Location> locs;
        Env.newLogger("/tmp/debugger");
        Sink s = new Sink();
        s.start();
        String myHost = "localhost";
        if (new File("locs.txt").exists() && (locs = Location.parseFile("locs.txt")) != null) {
            String hisHost = locs.get(0).host();
            myHost = TCPCommunicator.determineIP(hisHost, 22).toString();
        }
        String myProg = "Example.Client3";
        String cmd = "xterm -hold -e env CTL_DEBUGGER=" + myHost + ":" + s.getPort() + " java -Dfile.encoding=ISO-8859-1 " + myProg;
        try {
            System.out.println(Process.exec(cmd));
        }
        catch (Exception e) {
            System.out.println("Could not start process:");
            e.printStackTrace();
            System.exit(11);
        }
        System.out.println("Received " + recv + " bytes.");
    }

    private static void sendContinuous(Sink sink, Socket sock) {
        try {
            Header head = new Header(0L, 4, sink.getPID(), -1);
            OutputStream out0 = sock.getOutputStream();
            OOStream out1 = new OOStream(out0);
            out1.serialWrite(head);
            out1.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Handler
    extends Thread {
        private int id = -1;
        private Sink sink = null;
        private Socket sock = null;

        public Handler(Socket sock, int id, Sink sink) {
            this.id = id;
            this.sink = sink;
            this.sock = sock;
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            try {
                BufferedInputStream read = new BufferedInputStream(this.sock.getInputStream());
                OIStream in = new OIStream(read);
                while (this.sock.isConnected()) {
                    Header head = in.serialRead(Header.class);
                    int size = (int)head.getSize();
                    System.out.println(this.id + ": " + head);
                    recv += head.size();
                    if (size > 0x4000000) {
                        return;
                    }
                    if (size > 0) {
                        byte[] buf = new byte[size];
                        in.read(buf);
                        recv += size;
                    }
                    DummyDebugger.sendContinuous(this.sink, this.sock);
                }
                this.sock.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Sink
    extends Thread {
        private int port = -1;
        private ServerSocket ssock = null;
        private LinkedList<Socket> dudes = new LinkedList();

        public Sink() {
            try {
                this.ssock = new ServerSocket(0, 25);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.port = this.ssock.getLocalPort();
        }

        @Override
        public void run() {
            Thread.currentThread().setPriority(1);
            if (this.ssock == null) {
                return;
            }
            int i = 0;
            while (true) {
                try {
                    while (true) {
                        Socket sock = this.ssock.accept();
                        System.out.println("New connection from " + sock.getRemoteSocketAddress());
                        this.dudes.add(sock);
                        Handler handle = new Handler(sock, i, this);
                        handle.start();
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public int getPort() {
            return this.port;
        }

        public PeerID getPID() throws UnknownHostException {
            return new PeerID("localhost", this.port);
        }

        public LinkedList<Socket> getDudes() {
            return this.dudes;
        }
    }

    private static class ManualContinue
    extends Thread {
        private Sink sink;

        public ManualContinue(Sink s) {
            this.sink = s;
        }

        public void run() {
            block2: while (true) {
                try {
                    int c = System.in.read();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(3);
                }
                Iterator i$ = this.sink.getDudes().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Socket sock = (Socket)i$.next();
                    DummyDebugger.sendContinuous(this.sink, sock);
                }
                break;
            }
        }
    }
}

