/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.ObjectMap;
import CTL.RUtil;
import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import ReflWrap.TemplHack;
import ReflWrap.TypeTree;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference<T>
implements Writable,
TemplHack {
    private static ObjectMap map = new ObjectMap();
    private boolean first = false;
    private long typeID = 0L;
    private TypeTree type = null;

    @Override
    public void setTypes(TypeTree[] types) {
        if (types != null) {
            this.type = types[0];
        }
    }

    public boolean first() {
        return this.first;
    }

    public boolean equals(Object moo) {
        if (!(moo instanceof Reference)) {
            return false;
        }
        return this.typeID == ((Reference)moo).typeID();
    }

    public String toString() {
        return "Reference[" + this.typeID + "] --> " + this.obj() + " (" + this.first + ")";
    }

    public static void cleanup() {
        map = new ObjectMap();
    }

    public static void debug() {
        map.dump();
    }

    public long typeID() {
        return this.typeID;
    }

    public T obj() {
        return (T)map.getObj((int)this.typeID);
    }

    public static int unique() {
        return map.getCounter();
    }

    public Reference(Object obj) {
        if (obj == null) {
            return;
        }
        this.typeID = obj.hashCode();
        if (map.getObj((int)this.typeID) == null) {
            map.regObj(obj);
            this.first = true;
        }
    }

    @Override
    public void read(SerialIn in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.first = in.readBoolean();
        this.typeID = in.readLong();
        if (this.first) {
            in.readInt();
            Object obj = in.serialRead(this.type);
            if (obj == null) {
                throw new IOException("Reference to a null Object.");
            }
            map.regObj(obj, (int)this.typeID);
        }
    }

    @Override
    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        if (this.typeID == 0L) {
            out.writeBoolean(false);
            out.writeLong(-1L);
            return;
        }
        out.writeBoolean(this.first);
        out.writeLong(this.typeID);
        if (!this.first) {
            return;
        }
        Object obj = map.getObj((int)this.typeID);
        out.writeInt(RUtil.objSize(obj));
        out.serialWrite(obj);
    }
}

