/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import CTL.Types.IPaddr;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;

public class PeerID
implements Writable {
    private IPaddr host;
    private int port;

    public PeerID(IPaddr host, int port) {
        this.host = host;
        this.port = port;
    }

    public PeerID(String host, int port) throws UnknownHostException {
        this(new IPaddr(host), port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public IPaddr host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public void setHost(IPaddr host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void read(SerialIn in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.port = in.readInt();
        this.host = in.serialRead(IPaddr.class);
    }

    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeInt(this.port);
        out.serialWrite(this.host);
    }

    public int size() {
        return 20;
    }
}

