/*
 * Decompiled with CFR 0.152.
 */
package CTL.Types;

import CTL.Env;
import CTL.Measure;
import CTL.Remote;
import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Serialize.Writable;
import CTL.Types.CTLException;
import CTL.Types.GroupInfo;
import CTL.Types.IPaddr;
import CTL.Types.PeerID;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;

public class Header
extends Measure
implements Writable {
    private long size;
    private int tag;
    private PeerID pid;
    private int logID;
    private boolean needSwap = false;

    public Header(long size, int tag, PeerID pid, int logID) {
        this.size = size;
        this.tag = tag;
        this.pid = pid;
        this.logID = logID;
    }

    public Header(long size, int tag, IPaddr host, int port, int logID) {
        this(size, tag, new PeerID(host, port), logID);
    }

    public Header(long size, int tag, GroupInfo grp) {
        this(size, tag, grp == null ? null : grp.pid(), -1);
    }

    public String toString() {
        return this.size + " " + Remote.parseMType(this.tag) + " " + this.logID + "@" + this.pid;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public PeerID pid() {
        return this.pid;
    }

    public int tag() {
        return this.tag;
    }

    public void read(SerialIn in) throws IOException, InvocationTargetException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        short order = in.readShort();
        Env.log.msg(7, "Identifying byte-order using " + order);
        if (order > 1) {
            Env.log.msg(7, "Swapping bytes...");
            in.changeEndianess(ByteOrder.LITTLE_ENDIAN);
            this.needSwap = true;
        }
        this.size = in.readLong();
        this.tag = in.readInt();
        this.pid = in.serialRead(PeerID.class);
        this.logID = in.readInt();
    }

    public void write(SerialOut out) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        out.writeShort(1);
        out.writeLong(this.size);
        out.writeInt(this.tag);
        out.serialWrite(this.pid);
        out.writeInt(this.logID);
    }

    public boolean needSwap() {
        return this.needSwap;
    }
}

