/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.RI;
import CodeGen.GeneratedFluffFilter;
import NCLib.Classes;
import NCLib.Strings;
import ReflWrap.ByteCode;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToolBase {
    protected String whereAmI() {
        String clname = ByteCode.sed(this.getClass().getName(), "\\.", "/") + ".class";
        URL url = ClassLoader.getSystemResource(clname);
        return url.toString();
    }

    protected String whereAmI(Type type) {
        String res = this.whereAmI();
        switch (type) {
            case FILE: {
                if (!res.startsWith("file:")) break;
                StringTokenizer tok = new StringTokenizer(res, ":");
                tok.nextToken();
                return ByteCode.sed(tok.nextToken(), "/build.*", "");
            }
        }
        return null;
    }

    protected static LinkedList<String> findCIs() {
        return ToolBase.findCIs("javaSys");
    }

    protected static LinkedList<String> findCIs(String dirname) {
        LinkedList<String> ret = new LinkedList<String>();
        for (File f : new File(dirname).listFiles(new GeneratedFluffFilter())) {
            String fname = ByteCode.sed(f.toString(), "\\.java", "");
            fname = ByteCode.sed(fname, "/", "\\.");
            ret.add(fname);
        }
        return ret;
    }

    protected static LinkedList<String> findImpls() {
        return ToolBase.findClasses("Impl");
    }

    protected static LinkedList<String> findClasses(String dirname) {
        LinkedList<String> ret = new LinkedList<String>();
        if (!new File(dirname).exists()) {
            return ret;
        }
        for (File f : new File(dirname).listFiles()) {
            String clname = f.toString();
            if (Strings.endsWith(clname, ".svn") || Strings.endsWith(clname, ".cvsignore") || Strings.endsWith(clname, "CVS")) continue;
            if (f.isDirectory()) {
                ret.addAll(ToolBase.findClasses(clname));
                continue;
            }
            clname = ByteCode.sed(clname, "\\.class", "");
            clname = ByteCode.sed(clname, "\\.java", "");
            clname = ByteCode.sed(clname, "/", "\\.");
            clname = ByteCode.sed(clname, "\\\\", "\\.");
            ret.add(clname);
        }
        return ret;
    }

    protected static void loadClasses(LinkedList<String> files) {
        if (files == null) {
            return;
        }
        for (String clname : files) {
            try {
                Class<?> moongoo = Class.forName(clname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static LinkedList<String> findAllCIs() {
        LinkedList<String> res = new LinkedList<String>();
        for (Class c : Classes.getClasses()) {
            if (c.getSuperclass() != RI.class || res.indexOf(c.getName()) != -1) continue;
            res.add(c.getName());
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        UNDEF,
        FILE,
        JAR;

    }
}

