/*
 * Decompiled with CFR 0.152.
 */
package CTL.Serialize;

import CTL.Env;
import CTL.Java;
import CTL.RUtil;
import CTL.Serialize.Writable;
import CTL.Streams.DataInputStream2;
import CTL.Types.CTLException;
import CTL.Types.Tupel;
import ReflWrap.ClassInfo;
import ReflWrap.ConstructInfo;
import ReflWrap.Refl;
import ReflWrap.TemplHack;
import ReflWrap.TypeTree;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerialIn
extends DataInputStream2 {
    public SerialIn(InputStream in) throws IOException {
        super(in);
    }

    public abstract String readString() throws IOException;

    public abstract String readWString() throws IOException;

    public abstract <T> T[] readArray(Class<T> var1, LinkedList<TypeTree> var2) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException;

    public abstract <T> T[] __readArray(Class<T> var1, LinkedList<TypeTree> var2, int var3) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException;

    public abstract Tupel readTupel(Class[] var1) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CTLException;

    public abstract Object readObject() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException;

    public Object serialRead(Class ... args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.serialRead(new TypeTree(args));
    }

    public <T> T serialRead(Class<T> klass) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return (T)this.serialRead(new TypeTree(klass));
    }

    public Object serialRead(TypeTree tree) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class klass = tree.getType();
        Object[] targs = tree.getTypeArray();
        ClassInfo cinfo = new ClassInfo(klass);
        Env.log.msg(7, "Reading: " + klass + " " + Arrays.toString(targs));
        try {
            if (klass.equals(String.class)) {
                return this.readString();
            }
            if (klass.isArray()) {
                LinkedList<TypeTree> list = new LinkedList<TypeTree>();
                for (int i = 0; i < targs.length; ++i) {
                    list.add((TypeTree)targs[i]);
                }
                return this.readArray(cinfo.arrayType(), list);
            }
            if (klass.equals(Boolean.class) || klass.equals(Boolean.TYPE)) {
                return this.readBoolean();
            }
            if (klass.equals(Byte.class) || klass.equals(Byte.TYPE)) {
                return this.readByte();
            }
            if (klass.equals(Character.class) || klass.equals(Character.TYPE)) {
                return Character.valueOf(this.readChar());
            }
            if (klass.equals(Double.class) || klass.equals(Double.TYPE)) {
                return this.readDouble();
            }
            if (klass.equals(Float.class) || klass.equals(Float.TYPE)) {
                return Float.valueOf(this.readFloat());
            }
            if (klass.equals(Integer.class) || klass.equals(Integer.TYPE)) {
                return this.readInt();
            }
            if (klass.equals(Long.class) || klass.equals(Long.TYPE)) {
                return this.readLong();
            }
            if (klass.equals(Short.class) || klass.equals(Short.TYPE)) {
                return this.readShort();
            }
            if (klass.equals(LinkedList.class)) {
                return Java.readLinkedList(this, (TypeTree)targs[0]);
            }
            if (klass.equals(HashMap.class)) {
                return Java.readHashMap(this, (TypeTree)targs[0]);
            }
            if (klass.equals(HashSet.class)) {
                return Java.readHashSet(this, (TypeTree)targs[0]);
            }
            if (klass.equals(Stack.class)) {
                return Java.readStack(this, (TypeTree)targs[0]);
            }
            if (klass.equals(Vector.class)) {
                return Java.readVector(this, (TypeTree)targs[0]);
            }
            if (klass.equals(TypeTree.class)) {
                return Java.readTypeTree(this);
            }
            if (!cinfo.implementing("CTL.Serialize.Writable")) {
                String msg = "OIStream: Class " + cinfo.fqcn() + " does not implement the Writable-Interface.";
                System.out.println(RUtil.stackTrace());
                Env.log.msg(2, msg);
                throw new RuntimeException(msg);
            }
            ConstructInfo constr = new ConstructInfo(cinfo.constructors()[0]);
            Object[] args = new Object[constr.params().length];
            for (int i = 0; i < constr.params().length; ++i) {
                args[i] = Refl.defaultVal2(constr.params()[i]);
                Env.log.msg(7, "Default param: " + constr.params()[i] + ": " + args[i]);
            }
            Object ret = constr.c().newInstance(args);
            if (cinfo.implementing("ReflWrap.TemplHack")) {
                ((TemplHack)ret).setTypes((TypeTree[])targs);
            }
            ((Writable)ret).read(this);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }
}

