/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Env;
import CTL.RI;
import CTL.Serialize.SerialIn;
import CTL.Serialize.SerialOut;
import CTL.Streams.DataInputStream2;
import CTL.Streams.DataOutputStream2;
import CTL.Streams.OOStream;
import CTL.Types.CTLException;
import CTL.Types.PeerID;
import CTL.rResult;
import NCLib.Strings;
import ReflWrap.ClassInfo;
import ReflWrap.Refl;
import ReflWrap.TypeTree;
import gnu.getopt.Getopt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class RUtil {
    public static Method serialrd;
    public static Method serialrd2;
    public static Method serialwr;
    private static int halt;

    public static String stackTrace(Exception e) {
        String trace = RUtil.__stackTrace(e.getStackTrace());
        String msg = "";
        if (e.getClass().getName().equals("CTL.CTLException")) {
            msg = ((CTLException)e).getMsg();
        }
        return e + ": " + msg + System.getProperty("line.separator") + trace;
    }

    private static String __stackTrace(StackTraceElement[] trace) {
        return RUtil.__stackTrace(trace, trace.length);
    }

    private static String __stackTrace(StackTraceElement[] trace, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buf.append("\t\t" + trace[i].toString() + (i == trace.length - 1 ? "" : System.getProperty("line.separator")));
        }
        return buf.toString();
    }

    public static String stackTrace() {
        return RUtil.__stackTrace(Thread.currentThread().getStackTrace(), 5);
    }

    public static void except(Exception e) {
        Env.log.msg(5, e.toString());
        if (e.getClass().getName().equals("java.lang.reflect.InvocationTargetException")) {
            RUtil.except((Exception)((InvocationTargetException)e).getTargetException());
            return;
        }
        if (e.getClass().getName().equals("java.io.StreamCorruptedException")) {
            Env.log.msg(2, RUtil.stackTrace(e));
            throw new RuntimeException("Stream corrupted.");
        }
        if (e.getClass().getName().equals("java.io.OptionalDataException")) {
            Env.log.msg(2, "Stream is not intelligent enough.");
            Env.log.msg(2, RUtil.stackTrace(e));
            return;
        }
        if (e.getClass().getName().equals("java.net.ConnectException")) {
            String msg = "Connection error: " + e.getMessage();
            System.err.println(msg);
            Env.log.msg(2, msg);
            Env.log.msg(2, RUtil.stackTrace(e));
            throw new RuntimeException("Unexpected connection error.");
        }
        Env.log.msg(2, RUtil.stackTrace(e));
        if ((e.getClass().getName().equals("java.net.SocketException") || e.getClass().getName().equals("java.io.EOFException") || e.getClass().getName().equals("java.io.NotSerializableException") || e.getClass().getName().equals("java.net.SocketTimeoutException")) && !Env.isDebugger) {
            Env.log.msg(2, "Unrecoverable error.");
            System.exit(10);
        }
    }

    public static char getFID(Method method) {
        ClassInfo cinfo = new ClassInfo(method.getDeclaringClass());
        Method[] mm = cinfo.methods();
        for (int i = 0; i < mm.length; ++i) {
            if (!mm[i].equals(method)) continue;
            return (char)i;
        }
        return '\uffff';
    }

    public static char getCID(Constructor construct) {
        Constructor<?>[] cc = construct.getDeclaringClass().getConstructors();
        for (int i = 0; i < cc.length; ++i) {
            if (!cc[i].equals(construct)) continue;
            return (char)i;
        }
        return '\uffff';
    }

    public static Method getReader(String type) {
        Method m = null;
        String type2 = Refl.convert(type);
        Class[] args = null;
        if (type.charAt(type.length() - 1) == ']') {
            type2 = "Array";
        }
        if (type2.equals("Array")) {
            args = new Class[]{Class.class};
        }
        try {
            m = SerialIn.class.getDeclaredMethod("read" + type2, args);
        }
        catch (NoSuchMethodException e) {
            try {
                m = DataInputStream2.class.getDeclaredMethod("read" + type2, args);
            }
            catch (NoSuchMethodException e2) {
                return RUtil.getReader("Object");
            }
        }
        return m;
    }

    public static Method getWriter(String type) {
        Class[] args = new Class[1];
        Method m = null;
        String type2 = Refl.convert(type);
        args[0] = Refl.getClass(type2);
        try {
            m = SerialOut.class.getDeclaredMethod("write" + type2, args);
        }
        catch (NoSuchMethodException e) {
            try {
                m = DataOutputStream2.class.getDeclaredMethod("write" + type2, args);
            }
            catch (NoSuchMethodException e2) {
                return RUtil.getWriter("Object");
            }
        }
        return m;
    }

    public static Method getReceiver(String type) {
        Method m = null;
        Class[] args = new Class[2];
        String type2 = Refl.convert(type);
        if (!type.equals("Object")) {
            halt = 0;
        }
        try {
            args[0] = Refl.getClass(type2);
            args[1] = Integer.TYPE;
            m = rResult.class.getDeclaredMethod("receive", args);
        }
        catch (NoSuchMethodException e) {
            if (halt > 5) {
                return null;
            }
            ++halt;
            return RUtil.getReceiver("Object");
        }
        return m;
    }

    public static String reader2str(String reader) {
        StringTokenizer tok = new StringTokenizer(reader, "d");
        tok.nextToken();
        String foo = tok.nextToken(" ");
        return new String(foo.getBytes(), 1, foo.length() - 1);
    }

    public static Class classToRI(Class klas) throws ClassNotFoundException {
        if (Strings.endsWith(klas.toString(), "Debug")) {
            return klas;
        }
        ClassInfo cinfo = new ClassInfo(klas);
        String name = "javaSys." + cinfo.name();
        name = name.endsWith("CTLI") ? name.substring(0, name.length() - 4) : name + "CI";
        return Class.forName(name);
    }

    public static int objSize(Object obj) throws IOException, IllegalAccessException, InvocationTargetException, CTLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OOStream out = new OOStream(baos);
        if (obj == null) {
            return baos.toByteArray().length;
        }
        ClassInfo cinfo = new ClassInfo(obj.getClass());
        Method m = RUtil.getWriter(Refl.convert(cinfo.name()));
        if (m.getName().equals("writeObject")) {
            m = null;
        }
        if (m != null && m.getName().equals("writeArray")) {
            int sz = 0;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                sz += RUtil.objSize(Array.get(obj, i));
            }
            return sz;
        }
        if (m != null) {
            Object[] args = new Object[]{obj};
            m.invoke((Object)out, args);
        }
        out.serialWrite(obj);
        out.flush();
        int size = baos.toByteArray().length - RUtil.objSize(null);
        Env.log.msg(7, "sizeof(" + obj.getClass().getName() + ") = " + size);
        return size;
    }

    public static String converter(String type, String convert_me) {
        if (type.equals("boolean")) {
            return "((Boolean)" + convert_me + ").booleanValue()";
        }
        if (type.equals("byte")) {
            return "((Byte)" + convert_me + ").byteValue()";
        }
        if (type.equals("char")) {
            return "((Character)" + convert_me + ").charValue()";
        }
        if (type.equals("double")) {
            return "((Double)" + convert_me + ").doubleValue()";
        }
        if (type.equals("float")) {
            return "((Float)" + convert_me + ").floatValue()";
        }
        if (type.equals("int")) {
            return "((Integer)" + convert_me + ").intValue()";
        }
        if (type.equals("long")) {
            return "((Long)" + convert_me + ").longValue()";
        }
        if (type.equals("short")) {
            return "((Short)" + convert_me + ").shortValue()";
        }
        return "(" + type + ")" + convert_me;
    }

    public static int tryInt(String str) {
        int i = -1;
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    public static PeerID optPeerID(String arg) {
        StringTokenizer token = new StringTokenizer(arg, ":");
        String host = "localhost";
        int port = 0;
        try {
            host = token.nextToken();
            port = RUtil.tryInt(token.nextToken());
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (port == -1) {
            port = 0;
        }
        try {
            return new PeerID(host, port);
        }
        catch (UnknownHostException e) {
            try {
                return new PeerID("localhost", 0);
            }
            catch (UnknownHostException e2) {
                return null;
            }
        }
    }

    public static PeerID optPeerID(Getopt g) {
        return RUtil.optPeerID(g.getOptarg());
    }

    public static int optInt(Getopt g) {
        return RUtil.tryInt(g.getOptarg());
    }

    public static String optString(Getopt g) {
        return g.getOptarg();
    }

    public static String getBase(String name) {
        if (Strings.endsWith(name, "RI")) {
            name = name.substring(0, name.length() - 2) + "CI";
        }
        try {
            Constructor<?> c = Class.forName(name).getConstructor(Object.class);
            RI ri = (RI)c.newInstance(new Object[1]);
            return ri.getBase();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(RUtil.optPeerID("localhost:347784"));
        System.out.println(RUtil.optPeerID("localhost:foo"));
        System.out.println(RUtil.optPeerID("foo"));
        System.out.println(RUtil.tryInt("737834"));
        System.out.println(RUtil.tryInt("foo"));
    }

    static {
        Class[] args = new Class[1];
        try {
            args[0] = Object.class;
            serialwr = SerialOut.class.getDeclaredMethod("serialWrite", args);
            args[0] = Class.class;
            serialrd = SerialIn.class.getDeclaredMethod("serialRead", args);
            args[0] = TypeTree.class;
            serialrd2 = SerialIn.class.getDeclaredMethod("serialRead", args);
        }
        catch (Exception e) {
            throw new RuntimeException("Critical error.");
        }
    }
}

