/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.Annotate.builtin;
import CTL.Annotate.cdont;
import CTL.Annotate.dont;
import CTL.Comm.BuffyIn;
import CTL.Comm.BuffyOut;
import CTL.Comm.Communicator;
import CTL.Comm.HTTPCommunicator;
import CTL.Comm.TCPCommunicator;
import CTL.ConnectHandler;
import CTL.Env;
import CTL.RUtil;
import CTL.Remote;
import CTL.Types.CTLException;
import CTL.Types.GroupInfo;
import CTL.Types.Header;
import CTL.Types.IPaddr;
import CTL.Types.PeerID;
import ReflWrap.sFID;
import gnu.getopt.Getopt;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class Group
implements Runnable {
    private int myID;
    private int members;
    private long objID;
    protected GroupInfo[] grp;
    private boolean terminated = true;
    private Env env = null;

    @builtin
    @sFID(value=3)
    public void recvTermination(PeerID pid, String msg) {
        Env.log.msg(4, "recv TERM: " + pid + " - " + msg);
        System.exit(0);
    }

    @builtin
    @sFID(value=4)
    public static void recvException(String msg) {
        throw new RuntimeException(msg);
    }

    @cdont
    public Group(Env myEnv) {
        this.env = myEnv == null ? Env.newEnv() : myEnv;
        this.env.grp = this;
        String fe = System.getProperty("file.encoding");
        if (!fe.equals("ISO-8859-1")) {
            System.out.println("BUG: Bad file encoding '" + fe + "'.");
            System.exit(1);
        }
        Thread.currentThread().setPriority(1);
    }

    @cdont
    public Group(String host, int port, int myID, int members, int link, int myPort, Env myEnv) throws IOException, CTLException {
        this(myEnv);
        Env.newLogger("/tmp/client-" + myID);
        this.objID = Env.map.regObj(this);
        Env.log.msg(6, "Registered as " + this.objID + ".");
        this.env.comm = new Communicator[members];
        switch (link) {
            case 6: {
                this.env.comm[0] = new TCPCommunicator();
                this.env.comm[1] = new TCPCommunicator(host, port, myPort);
                break;
            }
            default: {
                throw new CTLException("Linkage not implemented.");
            }
        }
        this.env.comm[1].listen();
        this.updateGroup(myID, members);
        this.grp[myID] = new GroupInfo(this.env.comm[1].pid(), this.objID);
    }

    @cdont
    public Group(String host, int port, int myID, int members, int link, Env myEnv) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, CTLException {
        this(myEnv);
        if (myEnv == null) {
            Env.newLogger("/tmp/service");
            this.objID = Env.map.regObj(this);
            Env.log.msg(6, "Registered as " + this.objID + ".");
            this.env.comm = new Communicator[members];
            switch (link) {
                case 70: {
                    this.env.comm[0] = new HTTPCommunicator();
                    this.env.comm[1] = new HTTPCommunicator();
                    ((HTTPCommunicator)this.env.comm[0]).setPort(port);
                    break;
                }
                case 6: {
                    this.env.comm[0] = new TCPCommunicator(port);
                    this.env.comm[1] = new TCPCommunicator(port);
                    break;
                }
                default: {
                    throw new CTLException("Linkage not implemented.");
                }
            }
            this.env.comm[1].listen();
            this.updateGroup(myID, members);
            if (link == 6) {
                ((TCPCommunicator)this.env.comm[1]).setHost(new IPaddr(host));
                System.out.println(this.env.comm[1].pid().port());
            }
            this.grp[myID] = new GroupInfo(this.env.comm[1].pid(), this.objID);
            Env.daemon = true;
        } else {
            Env.newLogger("/tmp/client-" + myID);
            this.objID = Env.map.regObj(this);
            Env.log.msg(6, "Registered as " + this.objID + ".");
            this.env.comm = new Communicator[members];
            switch (link) {
                case 70: {
                    this.env.comm[0] = new HTTPCommunicator();
                    this.env.comm[1] = new HTTPCommunicator();
                    break;
                }
                case 6: 
                case 8: {
                    this.env.comm[0] = new TCPCommunicator();
                    this.env.comm[1] = new TCPCommunicator();
                    break;
                }
                default: {
                    throw new CTLException("Linkage not implemented.");
                }
            }
            this.env.comm[0].listen();
            this.env.comm[0].connect(new PeerID(host, port));
            this.readVersion(this.env.comm[0]);
            this.updateGroup(myID, members);
            this.grp[0] = new GroupInfo(new PeerID(host, port), 0L);
            this.grp[1] = new GroupInfo(this.env.comm[1].pid(), this.objID);
            Remote.writeDAT(this.env.comm[0], null, new IPaddr("1F3E:A28E:2CF0:9378:AA01:0744:5D31:710A", 0), this.env.comm[1].pid().port());
        }
    }

    @cdont
    public Group(String[] args) throws IOException, CTLException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        this((Env)null);
        int c;
        Env.newLogger("/tmp/service");
        this.objID = Env.map.regObj(this);
        Env.log.msg(6, "Registered as " + this.objID + ".");
        String proto = "file";
        IPaddr host = new IPaddr();
        int port = 0;
        int myID = 0;
        int members = 1;
        Getopt g = new Getopt("Example.Server", args, "D:C:vL:S:f:h:l:cp:P:");
        block19: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 68: {
                    Env.debugger = RUtil.optPeerID(g);
                    continue block19;
                }
                case 67: {
                    continue block19;
                }
                case 118: {
                    continue block19;
                }
                case 76: {
                    port = RUtil.optInt(g);
                    continue block19;
                }
                case 112: {
                    myID = RUtil.optInt(g);
                    continue block19;
                }
                case 83: {
                    members = RUtil.optInt(g);
                    continue block19;
                }
                case 102: {
                    continue block19;
                }
                case 104: {
                    host = new IPaddr(RUtil.optString(g));
                    continue block19;
                }
                case 108: {
                    proto = RUtil.optString(g);
                    continue block19;
                }
                case 80: {
                    Env.debugID = RUtil.optInt(g);
                    continue block19;
                }
                case 99: {
                    continue block19;
                }
                case 120: {
                    continue block19;
                }
                case 103: {
                    continue block19;
                }
                case 100: {
                    continue block19;
                }
                case 115: {
                    continue block19;
                }
                case 82: {
                    continue block19;
                }
                case 63: {
                    Env.log.msg(2, "Unknown option " + (char)g.getOptopt() + " specified.");
                    continue block19;
                }
            }
            Env.log.msg(2, "getopt returned " + c);
        }
        Env.log.msg(5, proto + "://" + host + ":" + port + " - " + myID + "/" + members);
        this.env.comm = new Communicator[members];
        if (proto.equals("tcp")) {
            this.env.comm[0] = new TCPCommunicator();
            this.env.comm[1] = new TCPCommunicator();
        }
        this.env.comm[0].listen();
        PeerID myPID = this.env.comm[0].pid();
        Env.log.msg(7, "My PID: " + myPID);
        this.env.comm[0].connect(new PeerID(host, port));
        this.readVersion(this.env.comm[0]);
        this.updateGroup(myID, members);
        this.grp[1] = new GroupInfo(myPID, this.objID);
        Env.log.msg(6, "Sending handshake to " + host + ":" + port);
        this.HS_send();
    }

    @dont
    private void updateGroup(int myID, int members) {
        this.myID = myID;
        this.members = members;
        if (members > 0) {
            this.grp = new GroupInfo[members];
        }
    }

    @dont
    public void printInfo() {
        Env.log.msg(6, "I am " + this.toString() + " on " + this.grp[this.myID].toString());
    }

    @dont
    public void readVersion(Communicator comm) throws IOException, CTLException {
        byte[] buf = comm.recv(19L);
        Env.log.msg(4, new String(buf));
    }

    @dont
    public void writeVersion(Communicator comm) throws IOException {
        String str = "CTL v0.9 Java      ";
        comm.send(str.getBytes(), false);
    }

    @dont
    public void run() {
        if (Env.daemon) {
            try {
                this.env.comm[1].accept();
                this.writeVersion(this.env.comm[1]);
                Header head = (Header)Remote.readDAT(this.env.comm[1], "HEAD");
                IPaddr magic = new IPaddr("1F3E:A28E:2CF0:9378:AA01:0744:5D31:710A", 0);
                if (!head.pid().host().equals(magic)) {
                    Env.log.msg(2, "Magic numbers do not match.");
                    throw new RuntimeException("Magic numbers do not match.");
                }
            }
            catch (Exception e) {
                RUtil.except(e);
            }
        }
        this.recv();
    }

    @dont
    protected void recv() {
        this.terminated = false;
        while (!this.terminated) {
            new ConnectHandler(this.env).run();
        }
    }

    @dont
    protected void HS_recv() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException, CTLException {
        BuffyIn in = new BuffyIn(this.env.comm[1].recv());
        in.i.serialRead(Header.class);
        Remote.writeHS(this.grp[0], this.env.comm[1]);
        this.grp[1] = Remote.readHS(this.env.comm[1]);
        Env.log.msg(4, "Handshake received.");
    }

    @dont
    protected void HS_send() throws IOException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, CTLException {
        Header head = new Header(0L, 1, new IPaddr("1F3E:A28E:2CF0:9378:AA01:0744:5D31:710A", 0), this.env.comm[0].pid().port(), this.myID());
        Env.log.msg(7, "HS_send(): " + head);
        BuffyOut out = new BuffyOut();
        out.o.serialWrite(head);
        out.o.flush();
        this.env.comm[0].send(out.getBytes());
        Env.log.msg(4, "Sending handshake.");
        this.grp[0] = Remote.readHS(this.env.comm[0]);
        Env.log.msg(7, "Client's GroupInfo: " + this.grp[0]);
        Remote.writeHS(this.grp[1], this.env.comm[0]);
        Env.log.msg(7, "My GroupInfo: " + this.grp[1]);
        Env.log.msg(4, "Handshake sent.");
    }

    @dont
    public boolean running() {
        return !this.terminated;
    }

    @dont
    public void terminate() {
        this.terminated = true;
    }

    @dont
    public int myID() {
        return this.myID;
    }

    @dont
    public int members() {
        return this.members;
    }

    @dont
    public String toString() {
        return this.myID + "/" + this.members;
    }

    @dont
    public GroupInfo groupInfo(int id) {
        return this.grp[id];
    }

    @dont
    public GroupInfo myInfo() {
        return this.grp[this.myID];
    }
}

