/*
 * Decompiled with CFR 0.152.
 */
package CTL.Comm;

import CTL.Env;
import CTL.Types.Location;
import com.apple.dnssd.BrowseListener;
import com.apple.dnssd.DNSSDException;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.ResolveListener;
import com.apple.dnssd.TXTRecord;
import java.util.HashMap;
import java.util.StringTokenizer;

public class DNSSD
implements BrowseListener,
RegisterListener,
ResolveListener {
    private boolean isReg = false;
    private HashMap<String, Location> map = new HashMap();

    public void operationFailed(DNSSDService service, int errorCode) {
        Env.log.msg(2, "DNS-SD " + (this.isReg ? "Registration" : "Browse") + " failed (err: " + errorCode + ").");
    }

    public void serviceRegistered(DNSSDRegistration reg, int flags, String name, String type, String domain) {
        Env.log.msg(4, "DNS-SD Registration successful (name: " + name + ", type: " + type + ", domain: " + domain);
    }

    public void serviceResolved(DNSSDService resolver, int flags, int ifIndex, String fullName, String hostName, int port, TXTRecord txtRecord) {
        StringTokenizer tok = new StringTokenizer(fullName, ".");
        String name = tok.nextToken();
        this.map.put(name, new Location(hostName + ":" + port + " dmn"));
    }

    public void serviceFound(DNSSDService browser, int flags, int ifIndex, String name, String type, String domain) {
        try {
            com.apple.dnssd.DNSSD.resolve((int)0, (int)0, (String)name, (String)type, (String)domain, (ResolveListener)this);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void serviceLost(DNSSDService browser, int flags, int ifIndex, String name, String regType, String domain) {
        this.map.remove(name);
    }

    public DNSSD() throws DNSSDException, InterruptedException {
        com.apple.dnssd.DNSSD.browse((String)"_ctl._tcp", (BrowseListener)this);
    }

    public DNSSD(String name, int port) throws DNSSDException, InterruptedException {
        this.isReg = true;
        com.apple.dnssd.DNSSD.register((String)name, (String)"_ctl._tcp", (int)port, (RegisterListener)this);
    }

    public String toString() {
        if (this.isReg) {
            return "DNSSD Registration object";
        }
        return this.map.toString();
    }

    public Location discover(String name) {
        if (this.isReg) {
            return null;
        }
        return this.map.get(name);
    }

    public static void main(String[] args) {
        try {
            Env.newLogger("/tmp/dnssd");
            DNSSD serv = new DNSSD("AddRI", 4849);
            DNSSD serv2 = new DNSSD("FooRI", 4850);
            DNSSD lookup = new DNSSD();
            Thread.sleep(5000L);
            System.out.println(serv + "\n" + serv2);
            System.out.println(lookup.discover("MooRI"));
            System.out.println(lookup.discover("FooRI"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

