/*
 * Decompiled with CFR 0.152.
 */
package CTL;

import CTL.ToolBase;
import NCLib.Files;
import NCLib.Template;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Admin
extends ToolBase {
    private static final boolean debug = true;

    private static String read1() {
        InputStreamReader read = new InputStreamReader(System.in);
        BufferedReader read2 = new BufferedReader(read);
        try {
            return read2.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void help() {
        System.out.println("\nCTL4j command line interface\n");
        System.out.println("Usage: CTL.Admin [command] [options]\n");
        System.out.println("Available commands:");
        System.out.println("quickstart\tCreate a new CTL4j project");
        System.exit(1);
    }

    private static void quickstart() {
        String dir = new Admin().whereAmI(ToolBase.Type.FILE);
        String name = "foobar";
        String comp = "moo";
        String dest = "/tmp";
        dest = dest + "/" + name;
        Files.mkdirOrDie(dest);
        Files.mkdirOrDie(dest + "/src");
        Files.mkdirOrDie(dest + "/src/Impl");
        Files.mkdirOrDie(dest + "/src/javaSys");
        Files.symlink(dir + "/src/Example.Server", dest + "/src/Server_");
        Files.writeAll(dest + "/locs.txt", "#lib\n" + System.getenv("USER") + "@localhost:" + dest + "/src/Server_ tcp\n");
        Files.writeAll(dest + "/src/Impl/" + comp + ".java", "package Impl;\n\npublic class " + comp + "\n{\n}\n");
        Files.writeAll(dest + "/src/Server.java", Files.readAll(dir + "/data/quickstart/Server.java"));
        Template buildXML = new Template(dir + "/data/quickstart/build.xml");
        buildXML.set("ctlloc", dir);
        buildXML.set("comp", comp);
        buildXML.write(dest + "/build.xml");
        Template client = new Template(dir + "/data/quickstart/Client.java");
        client.set("comp", comp);
        client.write(dest + "/src/Client.java");
        System.exit(0);
    }

    public static void main(String[] args) {
        Admin.quickstart();
        if (args.length < 1) {
            Admin.help();
        }
        if (args[0].equals("quickstart")) {
            Admin.quickstart();
        }
        Admin.help();
    }
}

